/*
 * Decompiled with CFR 0.152.
 */
package top.e404.skiko.gif;

import java.nio.ByteBuffer;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import top.e404.skiko.gif.UtilKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u0011\u001a\u00020\u0005J\u0006\u0010\u0012\u001a\u00020\u0007J\u0006\u0010\u0013\u001a\u00020\u0007J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006\u0019"}, d2={"Ltop/e404/skiko/gif/ColorTable;", "", "colors", "", "sort", "", "transparency", "", "background", "([IZII)V", "getBackground", "()I", "getColors", "()[I", "getSort", "()Z", "getTransparency", "exists", "s", "size", "write", "", "buffer", "Ljava/nio/ByteBuffer;", "Companion", "skiko-util-gif-codec"})
@SourceDebugExtension(value={"SMAP\nColorTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColorTable.kt\ntop/e404/skiko/gif/ColorTable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,43:1\n1#2:44\n*E\n"})
public final class ColorTable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final int[] colors;
    private final boolean sort;
    private final int transparency;
    private final int background;
    @NotNull
    private static final List<Integer> SizeList;
    @NotNull
    private static final ColorTable Empty;

    public ColorTable(@NotNull int[] colors, boolean sort, int transparency, int background) {
        Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
        this.colors = colors;
        this.sort = sort;
        this.transparency = transparency;
        this.background = background;
        if (!(ColorTable.Companion.capacity(this.colors) != -1)) {
            boolean bl = false;
            String string = "Color Table Too Large";
            throw new IllegalStateException(string.toString());
        }
    }

    public /* synthetic */ ColorTable(int[] nArray, boolean bl, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            n = RangesKt.coerceAtLeast((int)(ColorTable.Companion.capacity(nArray) - 1), (int)0);
        }
        if ((n3 & 8) != 0) {
            n2 = 0;
        }
        this(nArray, bl, n, n2);
    }

    @NotNull
    public final int[] getColors() {
        return this.colors;
    }

    public final boolean getSort() {
        return this.sort;
    }

    public final int getTransparency() {
        return this.transparency;
    }

    public final int getBackground() {
        return this.background;
    }

    public final int s() {
        return this.colors.length * 3 + (ColorTable.Companion.capacity(this.colors) - this.colors.length) * 3;
    }

    public final void write(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        for (int color : this.colors) {
            buffer.put(UtilKt.asRGBBytes(color));
        }
        buffer.put(new byte[(ColorTable.Companion.capacity(this.colors) - this.colors.length) * 3]);
    }

    public final boolean exists() {
        return !(this.colors.length == 0);
    }

    public final int size() {
        int n;
        int n2 = this.colors.length;
        boolean bl = 129 <= n2 ? n2 < 257 : false;
        if (bl) {
            n = 7;
        } else {
            boolean bl2 = 65 <= n2 ? n2 < 129 : false;
            if (bl2) {
                n = 6;
            } else {
                boolean bl3 = 33 <= n2 ? n2 < 65 : false;
                if (bl3) {
                    n = 5;
                } else {
                    boolean bl4 = 17 <= n2 ? n2 < 33 : false;
                    if (bl4) {
                        n = 4;
                    } else {
                        boolean bl5 = 9 <= n2 ? n2 < 17 : false;
                        if (bl5) {
                            n = 3;
                        } else {
                            boolean bl6 = 5 <= n2 ? n2 < 9 : false;
                            if (bl6) {
                                n = 2;
                            } else {
                                boolean bl7 = 3 <= n2 ? n2 < 5 : false;
                                if (bl7) {
                                    n = 1;
                                } else {
                                    boolean bl8 = 0 <= n2 ? n2 < 3 : false;
                                    if (bl8) {
                                        n = 0;
                                    } else {
                                        throw new IllegalArgumentException("Color Table Size: " + this.colors.length);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return n;
    }

    static {
        Object[] objectArray = new Integer[]{0, 2, 4, 8, 16, 32, 64, 128, 256};
        SizeList = CollectionsKt.listOf((Object[])objectArray);
        Empty = new ColorTable(new int[0], false, 0, 0, 12, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\n\u001a\u00020\t*\u00020\u000bH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ltop/e404/skiko/gif/ColorTable$Companion;", "", "()V", "Empty", "Ltop/e404/skiko/gif/ColorTable;", "getEmpty", "()Ltop/e404/skiko/gif/ColorTable;", "SizeList", "", "", "capacity", "", "skiko-util-gif-codec"})
    @SourceDebugExtension(value={"SMAP\nColorTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColorTable.kt\ntop/e404/skiko/gif/ColorTable$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,43:1\n288#2,2:44\n*S KotlinDebug\n*F\n+ 1 ColorTable.kt\ntop/e404/skiko/gif/ColorTable$Companion\n*L\n13#1:44,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final int capacity(int[] $this$capacity) {
            Object v0;
            block1: {
                Iterable $this$firstOrNull$iv = SizeList;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    int it = ((Number)element$iv).intValue();
                    boolean bl = false;
                    if (!(it >= $this$capacity.length)) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            Integer n = v0;
            return n != null ? n : -1;
        }

        @NotNull
        public final ColorTable getEmpty() {
            return Empty;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

