/*
 * Decompiled with CFR 0.152.
 */
package top.e404.skiko.util;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skia.Bitmap;
import org.jetbrains.skia.IRect;
import org.jetbrains.skia.Image;
import top.e404.skiko.util.Ahsb;
import top.e404.skiko.util.Argb;
import top.e404.skiko.util.Hsb;
import top.e404.skiko.util.ImageKt;
import top.e404.skiko.util.UtilKt;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a&\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006\u001a&\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u000b\u001a&\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003\u001a$\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003\u001a\u001e\u0010\u0012\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003\u001a\u001e\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006\u001a\u001e\u0010\u0014\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003\u001a\n\u0010\u0002\u001a\u00020\u0015*\u00020\u0003\u001a\n\u0010\u0016\u001a\u00020\u0003*\u00020\u0003\u001a\n\u0010\t\u001a\u00020\u0017*\u00020\u0003\u001a\n\u0010\u0018\u001a\u00020\u0003*\u00020\u0003\u001a\n\u0010\u0019\u001a\u00020\u0003*\u00020\u0003\u001a\u001e\u0010\u001a\u001a\u00020\u001b*\u00020\u001b2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u001d\u001a\n\u0010\u0013\u001a\u00020\u001e*\u00020\u0003\u001a\n\u0010\u001f\u001a\u00020\u0003*\u00020\u000b\u001a\n\u0010\u001f\u001a\u00020\u0003*\u00020\u0003\u001a\n\u0010 \u001a\u00020\u0003*\u00020\u0003\u001a\u001c\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030!*\u00020\u0003\u001a.\u0010\"\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060!*\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030!\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"pixelColorRange", "Lkotlin/ranges/IntRange;", "ahsb", "", "a", "h", "", "s", "b", "argb", "r", "", "g", "genColor", "", "start", "end", "count", "gray", "hsb", "rgb", "Ltop/e404/skiko/util/Ahsb;", "alpha", "Ltop/e404/skiko/util/Argb;", "blue", "green", "handlePixel", "Lorg/jetbrains/skia/Image;", "block", "Lkotlin/Function1;", "Ltop/e404/skiko/util/Hsb;", "limit", "red", "Lkotlin/Triple;", "toFloat", "skiko-util-util"})
public final class ColorKt {
    @NotNull
    private static final IntRange pixelColorRange = new IntRange(0, 255);

    @NotNull
    public static final Image handlePixel(@NotNull Image $this$handlePixel, @NotNull Function1<? super Integer, Integer> block) {
        Intrinsics.checkNotNullParameter((Object)$this$handlePixel, (String)"<this>");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Bitmap bitmap = UtilKt.toBitmap($this$handlePixel);
        Bitmap result = ImageKt.newBitmap$default($this$handlePixel, 0, 1, null);
        int n = result.getWidth();
        for (int x = 0; x < n; ++x) {
            int n2 = result.getHeight();
            for (int y = 0; y < n2; ++y) {
                int color = ((Number)block.invoke((Object)bitmap.getColor(x, y))).intValue();
                result.erase(color, IRect.Companion.makeXYWH(x, y, 1, 1));
            }
        }
        return UtilKt.toImage(result);
    }

    public static final int limit(double $this$limit) {
        return RangesKt.coerceIn((int)((int)$this$limit), (ClosedRange)((ClosedRange)pixelColorRange));
    }

    public static final int limit(int $this$limit) {
        return RangesKt.coerceIn((int)$this$limit, (ClosedRange)((ClosedRange)pixelColorRange));
    }

    @NotNull
    public static final Argb argb(int $this$argb) {
        return new Argb(ColorKt.alpha($this$argb), ColorKt.red($this$argb), ColorKt.green($this$argb), ColorKt.blue($this$argb));
    }

    @NotNull
    public static final Triple<Integer, Integer, Integer> rgb(int $this$rgb) {
        return new Triple((Object)ColorKt.red($this$rgb), (Object)ColorKt.green($this$rgb), (Object)ColorKt.blue($this$rgb));
    }

    public static final int alpha(int $this$alpha) {
        return (int)((long)$this$alpha >> 24);
    }

    public static final int red(int $this$red) {
        return ($this$red & 0xFF0000) >> 16;
    }

    public static final int green(int $this$green) {
        return ($this$green & 0xFF00) >> 8;
    }

    public static final int blue(int $this$blue) {
        return $this$blue & 0xFF;
    }

    @NotNull
    public static final Triple<Float, Float, Float> toFloat(@NotNull Triple<Integer, Integer, Integer> $this$toFloat) {
        Intrinsics.checkNotNullParameter($this$toFloat, (String)"<this>");
        return new Triple((Object)Float.valueOf(((Number)$this$toFloat.getFirst()).intValue()), (Object)Float.valueOf(((Number)$this$toFloat.getSecond()).intValue()), (Object)Float.valueOf(((Number)$this$toFloat.getThird()).intValue()));
    }

    public static final int rgb(int r, int g, int b) {
        return r << 16 | g << 8 | b;
    }

    public static final int argb(int a, int r, int g, int b) {
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static final int argb(int a, double r, double g, double b) {
        return ColorKt.argb(a, ColorKt.limit(r), ColorKt.limit(g), ColorKt.limit(b));
    }

    public static final int hsb(float h, float s, float b) {
        return Color.HSBtoRGB(h, s, b);
    }

    public static final int ahsb(int a, float h, float s, float b) {
        return Color.HSBtoRGB(h, s, b) | a << 24;
    }

    @NotNull
    public static final Ahsb ahsb(int $this$ahsb) {
        Argb argb = ColorKt.argb($this$ahsb);
        int a = argb.component1();
        int r = argb.component2();
        int g = argb.component3();
        int b = argb.component4();
        float[] it = Color.RGBtoHSB(r, g, b, null);
        boolean bl = false;
        return new Ahsb(a, it[0], it[1], it[2]);
    }

    @NotNull
    public static final Hsb hsb(int $this$hsb) {
        Triple<Integer, Integer, Integer> triple = ColorKt.rgb($this$hsb);
        int r = ((Number)triple.component1()).intValue();
        int g = ((Number)triple.component2()).intValue();
        int b = ((Number)triple.component3()).intValue();
        float[] it = Color.RGBtoHSB(r, g, b, null);
        boolean bl = false;
        return new Hsb(it[0], it[1], it[2]);
    }

    public static final int gray(int r, int g, int b) {
        return (int)(0.299 * (double)r + 0.587 * (double)g + 0.114 * (double)b);
    }

    @NotNull
    public static final List<Integer> genColor(int start, int end, int count) {
        ArrayList<Integer> arrayList;
        Triple<Integer, Integer, Integer> triple = ColorKt.rgb(start);
        int sr = ((Number)triple.component1()).intValue();
        int sg = ((Number)triple.component2()).intValue();
        int sb = ((Number)triple.component3()).intValue();
        Triple<Integer, Integer, Integer> triple2 = ColorKt.rgb(end);
        int er = ((Number)triple2.component1()).intValue();
        int eg = ((Number)triple2.component2()).intValue();
        int eb = ((Number)triple2.component3()).intValue();
        int rUnit = (er - sr) / (count - 1);
        int gUnit = (eg - sg) / (count - 1);
        int bUnit = (eb - sb) / (count - 1);
        ArrayList<Integer> $this$genColor_u24lambda_u242 = arrayList = new ArrayList<Integer>(count);
        boolean bl = false;
        $this$genColor_u24lambda_u242.add(start);
        int i = 1;
        int n = count - 2;
        if (i <= n) {
            while (true) {
                int r = sr + rUnit * i;
                int g = sg + gUnit * i;
                int b = sb + bUnit * i;
                $this$genColor_u24lambda_u242.add(ColorKt.rgb(r, g, b));
                if (i == n) break;
                ++i;
            }
        }
        $this$genColor_u24lambda_u242.add(end);
        return arrayList;
    }
}

