/*
 * Decompiled with CFR 0.152.
 */
package top.e404.skiko.util;

import java.awt.Color;
import java.io.Closeable;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.Bitmap;
import org.jetbrains.skia.ColorFilter;
import org.jetbrains.skia.ColorMatrix;
import org.jetbrains.skia.Font;
import org.jetbrains.skia.FontMetrics;
import org.jetbrains.skia.Image;
import org.jetbrains.skia.Surface;
import org.jetbrains.skia.TextLine;
import org.jetbrains.skia.Typeface;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u008c\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\u001a6\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005\u001a\u001a\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0012\u001a\u00020\t\u001a\u001a\u0010\u0013\u001a\u00020\u00142\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0012\u001a\u00020\t\u001a\u001a\u0010\u0015\u001a\u00020\u00162\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0012\u001a\u00020\t\u001a\u001a\u0010\u0017\u001a\u00020\t2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0012\u001a\u00020\t\u001a-\u0010\u0018\u001a\u00020\u0019*\u00020\u001a2!\u0010\u001b\u001a\u001d\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(\u001f\u0012\u0004\u0012\u00020\u00190\u001c\u001a\u0011\u0010 \u001a\u0004\u0018\u00010\u0005*\u00020\t\u00a2\u0006\u0002\u0010!\u001a\u001b\u0010\"\u001a\u0002H#\"\u0004\b\u0000\u0010#*\b\u0012\u0004\u0012\u0002H#0$\u00a2\u0006\u0002\u0010%\u001a\n\u0010&\u001a\u00020'*\u00020(\u001a\u0014\u0010)\u001a\u00020**\u0004\u0018\u00010\t2\u0006\u0010+\u001a\u00020*\u001a\u001f\u0010)\u001a\u0004\u0018\u00010**\u0004\u0018\u00010\t2\n\b\u0002\u0010+\u001a\u0004\u0018\u00010*\u00a2\u0006\u0002\u0010,\u001a\u0014\u0010-\u001a\u00020'*\u0004\u0018\u00010\t2\u0006\u0010+\u001a\u00020'\u001aB\u0010.\u001a\u00020/*\u00020\u001a26\u0010\u001b\u001a2\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(1\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(2\u0012\u0004\u0012\u00020\u001900\u001a-\u00103\u001a\u00020/*\u00020\u001a2!\u0010\u001b\u001a\u001d\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(\u001f\u0012\u0004\u0012\u00020\u00190\u001c\u001a\n\u00104\u001a\u00020'*\u00020(\u001a\u0014\u00105\u001a\u00020\u0005*\u0004\u0018\u00010\t2\u0006\u0010+\u001a\u00020\u0005\u001a\n\u00106\u001a\u000207*\u00020\u0016\u001a\u001b\u00108\u001a\u0002H#\"\u0004\b\u0000\u0010#*\b\u0012\u0004\u0012\u0002H#09\u00a2\u0006\u0002\u0010%\u001a\n\u0010:\u001a\u00020\u001a*\u00020\u0016\u001a\n\u0010;\u001a\u00020\u0016*\u00020\u001a\u001a\n\u0010<\u001a\u00020**\u00020*\u001a\n\u0010<\u001a\u00020**\u00020'\u001a\n\u0010<\u001a\u00020**\u00020\u0005\u001a\n\u0010<\u001a\u00020**\u00020=\u001a\n\u0010>\u001a\u00020'*\u00020(\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006?"}, d2={"grayMatrix", "Lorg/jetbrains/skia/ColorFilter;", "getGrayMatrix", "()Lorg/jetbrains/skia/ColorFilter;", "autoSize", "", "tf", "Lorg/jetbrains/skia/Typeface;", "text", "", "minSize", "maxSize", "maxWidth", "unit", "getJarFile", "", "cls", "Ljava/lang/Class;", "path", "getJarFileStream", "Ljava/io/InputStream;", "getJarImage", "Lorg/jetbrains/skia/Image;", "readJarFile", "any", "", "Lorg/jetbrains/skia/Bitmap;", "block", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "color", "asColor", "(Ljava/lang/String;)Ljava/lang/Integer;", "choose", "T", "", "(Ljava/util/List;)Ljava/lang/Object;", "descent", "", "Lorg/jetbrains/skia/Font;", "doubleOrPercentage", "", "default", "(Ljava/lang/String;Ljava/lang/Double;)Ljava/lang/Double;", "floatOrPercentage", "forEach", "", "Lkotlin/Function2;", "x", "y", "forEachColor", "height", "intOrPercentage", "newSurface", "Lorg/jetbrains/skia/Surface;", "takeRandom", "", "toBitmap", "toImage", "toRadian", "", "top", "skiko-util-util"})
public final class UtilKt {
    @NotNull
    private static final ColorFilter grayMatrix;

    @NotNull
    public static final InputStream getJarFileStream(@NotNull Class<?> cls, @NotNull String path) {
        Intrinsics.checkNotNullParameter(cls, (String)"cls");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        InputStream inputStream = cls.getClassLoader().getResourceAsStream(path);
        if (inputStream == null) {
            throw new IllegalArgumentException("Jar file: " + path + " is null");
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final byte[] getJarFile(@NotNull Class<?> cls, @NotNull String path) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter(cls, (String)"cls");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Closeable closeable = UtilKt.getJarFileStream(cls, path);
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            byArray = ByteStreamsKt.readBytes((InputStream)it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return byArray;
    }

    @NotNull
    public static final Image getJarImage(@NotNull Class<?> cls, @NotNull String path) {
        Intrinsics.checkNotNullParameter(cls, (String)"cls");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return Image.Companion.makeFromEncoded(UtilKt.getJarFile(cls, path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final String readJarFile(@NotNull Class<?> cls, @NotNull String path) {
        String string;
        Intrinsics.checkNotNullParameter(cls, (String)"cls");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Closeable closeable = UtilKt.getJarFileStream(cls, path);
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            string = new String(ByteStreamsKt.readBytes((InputStream)it), Charsets.UTF_8);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return string;
    }

    public static final double toRadian(double $this$toRadian) {
        return $this$toRadian * Math.PI / (double)180;
    }

    public static final double toRadian(float $this$toRadian) {
        return (double)$this$toRadian * Math.PI / (double)180;
    }

    public static final double toRadian(long $this$toRadian) {
        return (double)$this$toRadian * Math.PI / (double)180;
    }

    public static final double toRadian(int $this$toRadian) {
        return (double)$this$toRadian * Math.PI / (double)180;
    }

    public static final <T> T choose(@NotNull List<? extends T> $this$choose) {
        Intrinsics.checkNotNullParameter($this$choose, (String)"<this>");
        return $this$choose.get(Random.Default.nextInt($this$choose.size()));
    }

    public static final <T> T takeRandom(@NotNull List<T> $this$takeRandom) {
        Intrinsics.checkNotNullParameter($this$takeRandom, (String)"<this>");
        return $this$takeRandom.remove(Random.Default.nextInt($this$takeRandom.size()));
    }

    public static final float descent(@NotNull Font $this$descent) {
        Intrinsics.checkNotNullParameter((Object)$this$descent, (String)"<this>");
        return $this$descent.getMetrics().getDescent();
    }

    public static final float top(@NotNull Font $this$top) {
        Intrinsics.checkNotNullParameter((Object)$this$top, (String)"<this>");
        return $this$top.getMetrics().getTop();
    }

    public static final float height(@NotNull Font $this$height) {
        Intrinsics.checkNotNullParameter((Object)$this$height, (String)"<this>");
        FontMetrics $this$height_u24lambda_u242 = $this$height.getMetrics();
        boolean bl = false;
        return $this$height.getSize() + $this$height_u24lambda_u242.getDescent();
    }

    @NotNull
    public static final Image toImage(@NotNull Bitmap $this$toImage) {
        Intrinsics.checkNotNullParameter((Object)$this$toImage, (String)"<this>");
        return Image.Companion.makeFromBitmap($this$toImage);
    }

    @NotNull
    public static final Bitmap toBitmap(@NotNull Image $this$toBitmap) {
        Intrinsics.checkNotNullParameter((Object)$this$toBitmap, (String)"<this>");
        return Bitmap.Companion.makeFromImage($this$toBitmap);
    }

    @NotNull
    public static final Surface newSurface(@NotNull Image $this$newSurface) {
        Intrinsics.checkNotNullParameter((Object)$this$newSurface, (String)"<this>");
        return Surface.Companion.makeRaster($this$newSurface.getImageInfo());
    }

    public static final void forEach(@NotNull Bitmap $this$forEach, @NotNull Function2<? super Integer, ? super Integer, Boolean> block) {
        Intrinsics.checkNotNullParameter((Object)$this$forEach, (String)"<this>");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        int n = $this$forEach.getWidth();
        for (int x = 0; x < n; ++x) {
            int n2 = $this$forEach.getHeight();
            for (int y = 0; y < n2; ++y) {
                if (!((Boolean)block.invoke((Object)x, (Object)y)).booleanValue()) continue;
                return;
            }
        }
    }

    public static final void forEachColor(@NotNull Bitmap $this$forEachColor, @NotNull Function1<? super Integer, Boolean> block) {
        Intrinsics.checkNotNullParameter((Object)$this$forEachColor, (String)"<this>");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        UtilKt.forEach($this$forEachColor, (Function2<? super Integer, ? super Integer, Boolean>)((Function2)new Function2<Integer, Integer, Boolean>(block, $this$forEachColor){
            final /* synthetic */ Function1<Integer, Boolean> $block;
            final /* synthetic */ Bitmap $this_forEachColor;
            {
                this.$block = $block;
                this.$this_forEachColor = $receiver;
                super(2);
            }

            @NotNull
            public final Boolean invoke(int x, int y) {
                return (Boolean)this.$block.invoke((Object)this.$this_forEachColor.getColor(x, y));
            }
        }));
    }

    public static final boolean any(@NotNull Bitmap $this$any, @NotNull Function1<? super Integer, Boolean> block) {
        Intrinsics.checkNotNullParameter((Object)$this$any, (String)"<this>");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        int n = $this$any.getWidth();
        for (int x = 0; x < n; ++x) {
            int n2 = $this$any.getHeight();
            for (int y = 0; y < n2; ++y) {
                if (!((Boolean)block.invoke((Object)$this$any.getColor(x, y))).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    public static final int autoSize(@NotNull Typeface tf, @NotNull String text, int minSize, int maxSize, int maxWidth, int unit) {
        Intrinsics.checkNotNullParameter((Object)tf, (String)"tf");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        float size = minSize;
        TextLine line = TextLine.Companion.make(text, new Font(tf, size));
        while (!(size >= (float)maxSize)) {
            if (line.getWidth() >= (float)maxWidth) {
                return (int)size - unit;
            }
            line = TextLine.Companion.make(text, new Font(tf, size += (float)unit));
        }
        return (int)size;
    }

    @Nullable
    public static final Integer asColor(@NotNull String $this$asColor) {
        Integer n;
        Intrinsics.checkNotNullParameter((Object)$this$asColor, (String)"<this>");
        if (StringsKt.startsWith$default((String)$this$asColor, (String)"#", (boolean)false, (int)2, null)) {
            Integer n2;
            String s = StringsKt.removePrefix((String)$this$asColor, (CharSequence)"#");
            switch (s.length()) {
                case 3: {
                    StringBuilder stringBuilder;
                    StringBuilder $this$asColor_u24lambda_u244 = stringBuilder = new StringBuilder();
                    boolean bl = false;
                    int n3 = s.length();
                    for (int i = 0; i < n3; ++i) {
                        char c = s.charAt(i);
                        int n4 = 2;
                        int n5 = 0;
                        while (n5 < n4) {
                            int it = n5++;
                            boolean bl2 = false;
                            $this$asColor_u24lambda_u244.append(c);
                        }
                    }
                    String string = stringBuilder.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
                    Integer n6 = StringsKt.toIntOrNull((String)string, (int)16);
                    if (n6 != null) {
                        int it = ((Number)n6).intValue();
                        boolean bl3 = false;
                        n2 = (int)((long)it + 0xFF000000L);
                        break;
                    }
                    n2 = null;
                    break;
                }
                case 6: {
                    Integer n7 = StringsKt.toIntOrNull((String)s, (int)16);
                    if (n7 != null) {
                        int it = ((Number)n7).intValue();
                        boolean bl = false;
                        n2 = (int)((long)it + 0xFF000000L);
                        break;
                    }
                    n2 = null;
                    break;
                }
                default: {
                    n2 = null;
                }
            }
            return n2;
        }
        String string = $this$asColor.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        switch (string) {
            case "white": 
            case "\u767d": {
                n = Color.WHITE.getRGB();
                break;
            }
            case "lightGray": 
            case "\u6de1\u7070": 
            case "LIGHT_GRAY": {
                n = Color.LIGHT_GRAY.getRGB();
                break;
            }
            case "\u6df1\u7070": 
            case "darkGray": 
            case "DARK_GRAY": {
                n = Color.DARK_GRAY.getRGB();
                break;
            }
            case "\u9ed1": 
            case "black": {
                n = Color.BLACK.getRGB();
                break;
            }
            case "red": 
            case "\u7ea2": {
                n = Color.RED.getRGB();
                break;
            }
            case "pink": 
            case "\u7c89": {
                n = Color.PINK.getRGB();
                break;
            }
            case "\u6a58\u9ec4": 
            case "orange": {
                n = Color.ORANGE.getRGB();
                break;
            }
            case "\u9ec4": 
            case "yellow": {
                n = Color.YELLOW.getRGB();
                break;
            }
            case "green": 
            case "\u7eff": {
                n = Color.GREEN.getRGB();
                break;
            }
            case "magenta": 
            case "\u54c1\u7ea2": {
                n = Color.MAGENTA.getRGB();
                break;
            }
            case "cyan": 
            case "\u9752": {
                n = Color.CYAN.getRGB();
                break;
            }
            case "\u84dd": 
            case "blue": {
                n = Color.BLUE.getRGB();
                break;
            }
            default: {
                n = null;
            }
        }
        return n;
    }

    @NotNull
    public static final ColorFilter getGrayMatrix() {
        return grayMatrix;
    }

    public static final int intOrPercentage(@Nullable String $this$intOrPercentage, int n) {
        return $this$intOrPercentage == null ? n : (StringsKt.endsWith$default((String)$this$intOrPercentage, (String)"%", (boolean)false, (int)2, null) ? -Integer.parseInt(StringsKt.removeSuffix((String)$this$intOrPercentage, (CharSequence)"%")) : (Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)$this$intOrPercentage)).toString(), (Object)"") ? n : Integer.parseInt($this$intOrPercentage)));
    }

    public static final float floatOrPercentage(@Nullable String $this$floatOrPercentage, float f) {
        return $this$floatOrPercentage == null ? f : (StringsKt.endsWith$default((String)$this$floatOrPercentage, (String)"%", (boolean)false, (int)2, null) ? -Float.parseFloat(StringsKt.removeSuffix((String)$this$floatOrPercentage, (CharSequence)"%")) : (Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)$this$floatOrPercentage)).toString(), (Object)"") ? f : Float.parseFloat($this$floatOrPercentage)));
    }

    public static final double doubleOrPercentage(@Nullable String $this$doubleOrPercentage, double d) {
        return $this$doubleOrPercentage == null ? d : (StringsKt.endsWith$default((String)$this$doubleOrPercentage, (String)"%", (boolean)false, (int)2, null) ? -Double.parseDouble(StringsKt.removeSuffix((String)$this$doubleOrPercentage, (CharSequence)"%")) : (Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)$this$doubleOrPercentage)).toString(), (Object)"") ? d : Double.parseDouble($this$doubleOrPercentage)));
    }

    @Nullable
    public static final Double doubleOrPercentage(@Nullable String $this$doubleOrPercentage, @Nullable Double d) {
        return $this$doubleOrPercentage == null ? d : (StringsKt.endsWith$default((String)$this$doubleOrPercentage, (String)"%", (boolean)false, (int)2, null) ? Double.valueOf(-Double.parseDouble(StringsKt.removeSuffix((String)$this$doubleOrPercentage, (CharSequence)"%"))) : (Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)$this$doubleOrPercentage)).toString(), (Object)"") ? d : Double.valueOf(Double.parseDouble($this$doubleOrPercentage))));
    }

    public static /* synthetic */ Double doubleOrPercentage$default(String string, Double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = null;
        }
        return UtilKt.doubleOrPercentage(string, d);
    }

    static {
        float[] fArray = new float[]{0.33f, 0.38f, 0.29f, 0.0f, 0.0f, 0.33f, 0.38f, 0.29f, 0.0f, 0.0f, 0.33f, 0.38f, 0.29f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f};
        grayMatrix = ColorFilter.Companion.makeMatrix(new ColorMatrix(fArray));
    }
}

