/*
 * Decompiled with CFR 0.152.
 */
package org.jiang.tools.canvas;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import org.jiang.tools.canvas.EasyImage;

public final class EasyImageFactory {
    public static EasyImage buildNetworkImage(String url, int x, int y) throws IOException {
        return EasyImageFactory.buildNetworkImage(url, x, y, 0, 0, 0);
    }

    public static EasyImage buildNetworkImage(String url, int x, int y, int width, int height, int mode) throws IOException {
        BufferedImage image = ImageIO.read(new URL(url));
        return EasyImageFactory.build(image, x, y, width, height, mode);
    }

    public static EasyImage buildLocalImage(String url, int x, int y, int mode) throws IOException {
        return EasyImageFactory.buildLocalImage(url, x, y, 0, 0, mode);
    }

    public static EasyImage buildLocalImage(String url, int x, int y, int width, int height, int mode) throws IOException {
        BufferedImage image = ImageIO.read(new File(url));
        return EasyImageFactory.build(image, x, y, width, height, mode);
    }

    public static EasyImage build(Image image, int x, int y, int width, int height, int mode) {
        EasyImage easyImage = new EasyImage();
        easyImage.setImage(image);
        easyImage.setX(x);
        easyImage.setY(y);
        easyImage.setWidth(width);
        easyImage.setHeight(height);
        easyImage.setMode(mode);
        return easyImage;
    }
}

