/*
 * Decompiled with CFR 0.152.
 */
package org.jiang.tools.date;

import java.time.LocalDate;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Date;

public class DateCalculateUtils {
    public static long getDayDiff(Date startDate, Date endDate) {
        LocalDate startDateLD = startDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate endDateLD = endDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        return ChronoUnit.DAYS.between(startDateLD, endDateLD);
    }

    public static long getMonthDiff(Date startDate, Date endDate) {
        LocalDate startDateLD = startDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate endDateLD = endDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        YearMonth startMonth = YearMonth.from(startDateLD);
        YearMonth endMonth = YearMonth.from(endDateLD);
        return ChronoUnit.MONTHS.between(startMonth, endMonth);
    }

    public static long getYearDiff(Date startDate, Date endDate) {
        LocalDate startDateLD = startDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate endDateLD = endDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        Year startMonth = Year.from(startDateLD);
        Year endMonth = Year.from(endDateLD);
        return ChronoUnit.YEARS.between(startMonth, endMonth);
    }

    public static long getFullSecDiff(Date startDate, Date endDate) {
        long diffMs = endDate.getTime() - startDate.getTime();
        long diff = diffMs / 1000L;
        return (int)diff;
    }

    public static long getFullMinDiff(Date startDate, Date endDate) {
        long diffMs = endDate.getTime() - startDate.getTime();
        long diff = diffMs / 60000L;
        return (int)diff;
    }

    public static long getFullHourDiff(Date startDate, Date endDate) {
        long diffMs = endDate.getTime() - startDate.getTime();
        long diff = diffMs / 3600000L;
        return (int)diff;
    }

    public static long getFullDayDiff(Date startDate, Date endDate) {
        long diffMs = endDate.getTime() - startDate.getTime();
        long diff = diffMs / 86400000L;
        return (int)diff;
    }

    public static long getFullWeekDiff(Date startDate, Date endDate) {
        long diffMs = endDate.getTime() - startDate.getTime();
        long diff = diffMs / 604800000L;
        return (int)diff;
    }

    public static long getFullMonthDiff(Date startDate, Date endDate) {
        long diffMs = endDate.getTime() - startDate.getTime();
        long diff = diffMs / 2592000000L;
        return (int)diff;
    }

    public static long getFullYearDiff(Date startDate, Date endDate) {
        long diffMs = endDate.getTime() - startDate.getTime();
        long diff = diffMs / 31536000000L;
        return (int)diff;
    }
}

