/*
 * Decompiled with CFR 0.152.
 */
package org.jiang.tools.date;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jiang.tools.date.DateCalculateUtils;
import org.jiang.tools.date.dict.TextDict;
import org.jiang.tools.exception.BadArgumentException;
import org.jiang.tools.exception.SystemException;

public class DateFormatUtils {
    private static final String DEFAULT_FORMAT_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private static final Map<BiFunction<Date, Date, Long>, Function<TextDict, String>> DIFF_TEXT_FUN_MAP = new LinkedHashMap<BiFunction<Date, Date, Long>, Function<TextDict, String>>(6);

    public static Date toDate(String dateStr) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DEFAULT_FORMAT_PATTERN);
        return DateFormatUtils.parse(dateFormat, dateStr);
    }

    public static Date toDate(String dateStr, String pattern) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        return DateFormatUtils.parse(dateFormat, dateStr);
    }

    public static String toString(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DEFAULT_FORMAT_PATTERN);
        return dateFormat.format(date);
    }

    public static String toString(Date date, String pattern) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        return dateFormat.format(date);
    }

    public static String toWeek(Date date, TextDict textDict) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return textDict.weekList()[calendar.get(7) - 1];
    }

    public static String toDiffText(Date currentDate, Date date, TextDict textDict) {
        for (Map.Entry<BiFunction<Date, Date, Long>, Function<TextDict, String>> entry : DIFF_TEXT_FUN_MAP.entrySet()) {
            Long diff = entry.getKey().apply(date, currentDate);
            if (diff <= 0L) continue;
            return String.format(entry.getValue().apply(textDict), diff);
        }
        throw new BadArgumentException();
    }

    private static Date parse(SimpleDateFormat dateFormat, String dateStr) {
        try {
            return dateFormat.parse(dateStr);
        }
        catch (ParseException e) {
            throw new SystemException(e);
        }
    }

    static {
        DIFF_TEXT_FUN_MAP.put(DateCalculateUtils::getFullYearDiff, TextDict::getYearAgo);
        DIFF_TEXT_FUN_MAP.put(DateCalculateUtils::getFullMonthDiff, TextDict::getMonthAgo);
        DIFF_TEXT_FUN_MAP.put(DateCalculateUtils::getFullDayDiff, TextDict::getDayAgo);
        DIFF_TEXT_FUN_MAP.put(DateCalculateUtils::getFullHourDiff, TextDict::getHourAgo);
        DIFF_TEXT_FUN_MAP.put(DateCalculateUtils::getFullMinDiff, TextDict::getMinAgo);
        DIFF_TEXT_FUN_MAP.put(DateCalculateUtils::getFullSecDiff, TextDict::getSecAgo);
    }
}

