/*
 * Decompiled with CFR 0.152.
 */
package org.jiang.tools.lock;

import java.util.concurrent.atomic.AtomicReference;
import org.jiang.tools.lock.Lock;

public class SpinLock
implements Lock {
    private final AtomicReference<Thread> owner = new AtomicReference();
    private int count = 0;

    @Override
    public void lock() {
        Thread thread = Thread.currentThread();
        if (this.owner.get() == thread) {
            ++this.count;
            return;
        }
        while (!this.owner.compareAndSet(null, thread)) {
        }
    }

    @Override
    public void unlock() {
        Thread thread = Thread.currentThread();
        if (this.owner.get() != thread) {
            return;
        }
        if (this.count > 0) {
            --this.count;
            return;
        }
        this.owner.set(null);
    }
}

