/*
 * Decompiled with CFR 0.152.
 */
package org.jiang.tools.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import org.jiang.tools.exception.SystemException;
import org.jiang.tools.util.JsonUtils;

public class RequestResult<T>
implements Serializable {
    private String code;
    private T data;
    private String message;

    public RequestResult(String code) {
        this(code, null, null);
    }

    public static <T> RequestResult<T> build(String code, T data) {
        return new RequestResult<T>(code, data, null);
    }

    public static <T> RequestResult<T> build(String code, T data, String message) {
        return new RequestResult<T>(code, data, message);
    }

    public static RequestResult<?> success() {
        return RequestResult.success(null);
    }

    public static <T> RequestResult<T> success(T data) {
        return new RequestResult<T>("200", data, null);
    }

    public static RequestResult<?> fail() {
        return RequestResult.fail("\u7cfb\u7edf\u670d\u52a1\u5f02\u5e38");
    }

    public static RequestResult<?> fail(String message) {
        return new RequestResult<Object>("500", null, message);
    }

    public String toJson() {
        return JsonUtils.toJson(this);
    }

    public byte[] toBytes() {
        return this.toJson().getBytes();
    }

    @JsonIgnore
    public boolean isSuccess() {
        return "200".equals(this.code);
    }

    @JsonIgnore
    public T getSuccessData() {
        return this.getSuccessData("request fail");
    }

    @JsonIgnore
    public T getSuccessData(String message) {
        if (this.isSuccess()) {
            return this.data;
        }
        throw new SystemException(String.format("%s\uff1a%s", message, this.toJson()));
    }

    public String getCode() {
        return this.code;
    }

    public T getData() {
        return this.data;
    }

    public String getMessage() {
        return this.message;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setData(T data) {
        this.data = data;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public RequestResult() {
    }

    public RequestResult(String code, T data, String message) {
        this.code = code;
        this.data = data;
        this.message = message;
    }
}

