/*
 * Decompiled with CFR 0.152.
 */
package org.jiang.tools.template;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jiang.tools.template.ObjectPropertyUtils;
import org.jiang.tools.util.JsonUtils;
import org.jiang.tools.util.StringUtils;

public class JsonTemplateParser {
    private static final String REGEX_ESCAPE_CHARS = "$()*+.[]?\\^{}|";
    public static final String EXP_START_DEFAULT = "${";
    public static final String EXP_END_DEFAULT = "}";
    private final String expStart;
    private final String expEnd;
    private final String expPlaceholder;

    public JsonTemplateParser() {
        this(EXP_START_DEFAULT, EXP_END_DEFAULT);
    }

    public JsonTemplateParser(String expStart, String expEnd) {
        this.expStart = expStart;
        this.expEnd = expEnd;
        this.expPlaceholder = "(?<=" + this.regexEscape(expStart) + ").*?(?=" + this.regexEscape(expEnd) + ")";
    }

    public Map<String, Object> parsingToMap(String template, Object obj) {
        String str = this.parsingToString(template, obj);
        if (StringUtils.isEmpty(str)) {
            return null;
        }
        return JsonUtils.toBean(str, Map.class);
    }

    public String parsingToString(String template, Object obj) {
        Object value;
        Matcher matcher = Pattern.compile(this.expPlaceholder).matcher(template);
        HashMap<String, String> matched = new HashMap<String, String>(4);
        while (matcher.find()) {
            String exp = matcher.group();
            String fullExp = this.expStart + exp + this.expEnd;
            if (matched.containsKey(fullExp)) continue;
            value = ObjectPropertyUtils.extract(obj, exp);
            String strValue = this.objectToString(value);
            matched.put(fullExp, strValue);
        }
        for (String key : matched.keySet()) {
            value = (String)matched.get(key);
            template = template.replace(key, (CharSequence)value);
        }
        return template;
    }

    private String objectToString(Object obj) {
        if (obj == null) {
            return "null";
        }
        Class<Number> cls = obj.getClass();
        if (cls.isPrimitive()) {
            return obj.toString();
        }
        if (cls.isAssignableFrom(Number.class)) {
            return obj.toString();
        }
        if (obj instanceof CharSequence) {
            return obj.toString();
        }
        return JsonUtils.toJson(obj);
    }

    private String regexEscape(String str) {
        char[] cs;
        StringBuilder result = new StringBuilder();
        for (char c : cs = str.toCharArray()) {
            if (REGEX_ESCAPE_CHARS.indexOf(c) == -1) continue;
            result.append("\\");
            result.append(c);
        }
        return result.toString();
    }
}

