/*
 * Decompiled with CFR 0.152.
 */
package org.jiang.tools.util;

import java.util.function.Supplier;

public class Assert {
    public static <T> AssertResult<T> nonNull(T obj) {
        return AssertResult.build(obj, obj != null);
    }

    public static <T extends CharSequence> AssertResult<T> nonEmpty(T cs) {
        return AssertResult.build(cs, cs != null && cs.length() > 0);
    }

    public static class AssertResult<T> {
        private T obj;
        private boolean isTrue;

        public static <T> AssertResult<T> build(T t, boolean isTrue) {
            AssertResult<T> assertResult = new AssertResult<T>();
            assertResult.obj = t;
            assertResult.isTrue = isTrue;
            return assertResult;
        }

        public T or(T t) {
            if (this.isTrue) {
                return this.obj;
            }
            return t;
        }

        public T or(Supplier<T> supplier) {
            if (this.isTrue) {
                return this.obj;
            }
            return supplier.get();
        }

        public T orThrows(RuntimeException e) {
            if (this.isTrue) {
                return this.obj;
            }
            throw e;
        }

        public T orThrows(Supplier<RuntimeException> supplier) {
            if (this.isTrue) {
                return this.obj;
            }
            throw supplier.get();
        }
    }
}

