/*
 * Decompiled with CFR 0.152.
 */
package org.jiang.tools.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ListUtils {
    public static <T> List<T> asSet(Set<T> set) {
        ArrayList<T> list = new ArrayList<T>(set.size());
        list.addAll(set);
        return list;
    }

    public static <T, R> List<R> convert(List<T> list, Function<T, R> fun) {
        if (list == null) {
            return null;
        }
        return list.stream().map(fun).collect(Collectors.toList());
    }

    public static <T, K> List<T> distinct(List<T> list, Function<T, K> fun) {
        if (list == null) {
            return null;
        }
        HashMap<K, T> map = new HashMap<K, T>(list.size());
        ArrayList<T> result = new ArrayList<T>(list.size());
        for (T t : list) {
            K key = fun.apply(t);
            if (map.containsKey(key)) continue;
            map.put(key, t);
            result.add(t);
        }
        return result;
    }
}

