/*
 * Decompiled with CFR 0.152.
 */
package org.jiang.tools.verifycode;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.Random;
import org.jiang.tools.canvas.EasyCanvas;
import org.jiang.tools.canvas.EasyCanvasUtils;
import org.jiang.tools.canvas.EasyFont;
import org.jiang.tools.canvas.EasyLine;
import org.jiang.tools.canvas.EasyText;
import org.jiang.tools.util.ColorUtils;
import org.jiang.tools.verifycode.ImageVerifyCode;

public class ImageCodeFactory {
    private Integer width = 240;
    private Integer height = 80;
    private Integer complexity = 50;

    public ImageCodeFactory() {
    }

    public ImageCodeFactory(Integer width, Integer height) {
        this.width = width;
        this.height = height;
    }

    public ImageCodeFactory(Integer width, Integer height, Integer complexity) {
        this.width = width;
        this.height = height;
        this.complexity = complexity;
    }

    public ImageVerifyCode generate(String code) {
        Random random = new Random();
        EasyCanvas easyCanvas = new EasyCanvas(this.width, this.height, ColorUtils.getRandRandom(200, 250));
        int fontSize = this.width / code.length();
        for (int i = 0; i < code.length(); ++i) {
            EasyFont easyFont = new EasyFont(fontSize);
            int rotate = random.nextInt(90) - 45;
            easyFont.setRotate(rotate);
            EasyText easyText = new EasyText((int)((double)(fontSize * i) * 0.8 + (double)this.width.intValue() * 0.1), this.height / 2 - fontSize / 2 - rotate / 3, String.valueOf(code.charAt(i)), easyFont);
            easyText.setColor(ColorUtils.getRandRandom(20, 130));
            easyCanvas.add(easyText);
        }
        float noisyPointLine = (float)(this.width * this.height) * 1.0E-4f * (float)this.complexity.intValue();
        Color lineColor = ColorUtils.getRandRandom(160, 200);
        int i = 0;
        while ((float)i < noisyPointLine) {
            int x = random.nextInt(this.width - 1);
            int y = random.nextInt(this.height - 1);
            int ex = random.nextInt(this.width - 1);
            int ey = random.nextInt(this.height - 1);
            easyCanvas.add(new EasyLine(x, y, ex, ey, lineColor));
            ++i;
        }
        BufferedImage bufferedImage = EasyCanvasUtils.write(easyCanvas);
        float noisyPointCount = (float)(this.width * this.height) * 0.002f * (float)this.complexity.intValue();
        int i2 = 0;
        while ((float)i2 < noisyPointCount) {
            int x = random.nextInt(this.width);
            int y = random.nextInt(this.height);
            bufferedImage.setRGB(x, y, ColorUtils.getRandomInt());
            ++i2;
        }
        return new ImageVerifyCode(code, bufferedImage);
    }

    public Integer getWidth() {
        return this.width;
    }

    public Integer getHeight() {
        return this.height;
    }

    public Integer getComplexity() {
        return this.complexity;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public void setComplexity(Integer complexity) {
        this.complexity = complexity;
    }
}

