package org.jiang.tools.constants;

/**
 * 时长常量类
 *
 * @author Bin
 * @since 1.0.0
 */
public interface TimeConstants {

    /**
     * 1分钟，单位：秒
     */
    long MINUTE_S = 60;

    /**
     * 1小时，单位：秒
     */
    long HOUR_S = 3600;

    /**
     * 1天，单位：秒
     */
    long DAY_S = 86400;

    /**
     * 1周，单位：秒
     */
    long WEEK_S = 604800;

    /**
     * 1个月（30天），单位：秒
     */
    long MONTH_S = 2592000;

    /**
     * 1年（365天），单位：秒
     */
    long YEAR_S = 31536000;

    /**
     * 1秒，单位：毫秒
     */
    long SECOND_S = 1000;

    /**
     * 1分钟，单位：毫秒
     */
    long MINUTE_M = 60000;

    /**
     * 1小时，单位：毫秒
     */
    long HOUR_M = 3600000;

    /**
     * 1天，单位：毫秒
     */
    long DAY_M = 86400000;

    /**
     * 1周（7天），单位：毫秒
     */
    long WEEK_M = 604800000L;

    /**
     * 1个月（30天），单位：毫秒
     */
    long MONTH_M = 2592000000L;

    /**
     * 1年（365天），单位：毫秒
     */
    long YEAR_M = 31536000000L;

}
