/*
 * Decompiled with CFR 0.152.
 */
package org.jiang.tools.canvas.image;

import java.awt.Image;
import org.jiang.tools.canvas.element.EasyImage;
import org.jiang.tools.canvas.image.ImageDrawPosition;
import org.jiang.tools.exception.SystemException;

public class ImageModeUtils {
    public static ImageDrawPosition fit(EasyImage easyImage) {
        ImageDrawPosition position;
        switch (easyImage.getMode()) {
            case 1: {
                position = ImageModeUtils.fillFit(easyImage);
                break;
            }
            case 2: {
                position = ImageModeUtils.containFit(easyImage);
                break;
            }
            case 3: {
                position = ImageModeUtils.coverFit(easyImage);
                break;
            }
            default: {
                position = ImageModeUtils.noneFit(easyImage);
            }
        }
        return position;
    }

    public static ImageDrawPosition noneFit(EasyImage easyImage) {
        Image image = easyImage.getImage();
        ImageDrawPosition position = new ImageDrawPosition();
        position.setStartX(easyImage.getX());
        position.setStartY(easyImage.getY());
        position.setEndX(image.getWidth(null) + easyImage.getWidth());
        position.setEndY(image.getHeight(null) + easyImage.getHeight());
        position.setClipStartX(0);
        position.setClipStartY(0);
        position.setClipEndX(image.getWidth(null));
        position.setClipEndY(image.getHeight(null));
        return position;
    }

    public static ImageDrawPosition fillFit(EasyImage easyImage) {
        if (!easyImage.hasSize()) {
            throw new SystemException("size is incorrect");
        }
        Image image = easyImage.getImage();
        ImageDrawPosition position = new ImageDrawPosition();
        position.setStartX(easyImage.getX());
        position.setStartY(easyImage.getY());
        position.setEndX(easyImage.getX() + easyImage.getWidth());
        position.setEndY(easyImage.getY() + easyImage.getHeight());
        position.setClipStartX(0);
        position.setClipStartY(0);
        position.setClipEndX(image.getWidth(null));
        position.setClipEndY(image.getHeight(null));
        return position;
    }

    public static ImageDrawPosition containFit(EasyImage easyImage) {
        float ratio;
        if (!easyImage.hasSize()) {
            throw new SystemException("size is incorrect");
        }
        Image image = easyImage.getImage();
        ImageDrawPosition position = new ImageDrawPosition();
        int imageWidth = image.getWidth(null);
        int imageHeight = image.getHeight(null);
        int startX = easyImage.getX();
        int startY = easyImage.getY();
        if (imageWidth != easyImage.getWidth()) {
            ratio = (float)imageWidth / (float)easyImage.getWidth();
            imageWidth = easyImage.getWidth();
            imageHeight = (int)((float)imageHeight / ratio);
        }
        if (imageHeight > easyImage.getHeight()) {
            ratio = (float)imageHeight / (float)easyImage.getHeight();
            imageHeight = easyImage.getHeight();
            imageWidth = (int)((float)imageWidth / ratio);
        }
        int n = imageHeight == easyImage.getHeight() ? 0 : (easyImage.getHeight() - imageHeight) / 2;
        position.setStartX(startX += imageWidth == easyImage.getWidth() ? 0 : (easyImage.getWidth() - imageWidth) / 2);
        position.setStartY(startY += n);
        position.setEndX(startX + imageWidth);
        position.setEndY(startY + imageHeight);
        position.setClipStartX(0);
        position.setClipStartY(0);
        position.setClipEndX(image.getWidth(null));
        position.setClipEndY(image.getHeight(null));
        return position;
    }

    public static ImageDrawPosition coverFit(EasyImage easyImage) {
        if (!easyImage.hasSize()) {
            throw new SystemException("size is incorrect");
        }
        Image image = easyImage.getImage();
        int imageWidth = image.getWidth(null);
        int imageHeight = image.getHeight(null);
        int clipX = 0;
        int clipY = 0;
        int clipEndX = imageWidth;
        int clipEndY = imageHeight;
        ImageDrawPosition position = ImageModeUtils.containFit(easyImage);
        if (position.getEndX() < easyImage.getWidth()) {
            float ratio = (float)(position.getEndX() - easyImage.getX()) / (float)easyImage.getWidth();
            clipY = (int)((float)position.getClipEndY() - (float)position.getClipEndY() * ratio);
            clipEndY -= clipY;
        } else if (position.getEndY() < easyImage.getHeight()) {
            float ratio = (float)(position.getEndY() - easyImage.getY()) / (float)easyImage.getHeight();
            clipX = (int)((float)position.getClipEndX() - (float)position.getClipEndX() * ratio);
            clipEndX -= clipX;
        }
        position.setStartX(easyImage.getX());
        position.setStartY(easyImage.getY());
        position.setEndX(easyImage.getX() + easyImage.getWidth());
        position.setEndY(easyImage.getY() + easyImage.getHeight());
        position.setClipStartX(clipX);
        position.setClipStartY(clipY);
        position.setClipEndX(clipEndX);
        position.setClipEndY(clipEndY);
        return position;
    }
}

