/*
 * Decompiled with CFR 0.152.
 */
package org.jiang.tools.compress;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.jiang.tools.data.EasyData;
import org.jiang.tools.text.StringUtils;

public class GzipUtils {
    private static final int BUFFER_SIZE = 8192;

    public static EasyData compress(byte[] bytes) throws IOException {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (GZIPOutputStream gzipOutputStream = new GZIPOutputStream(byteArrayOutputStream);){
            gzipOutputStream.write(bytes);
        }
        return EasyData.of(byteArrayOutputStream.toByteArray());
    }

    public static EasyData compress(String str) throws IOException {
        if (StringUtils.isEmpty(str)) {
            return null;
        }
        return GzipUtils.compress(str.getBytes());
    }

    public static EasyData compress(EasyData data) throws IOException {
        if (data == null) {
            return null;
        }
        return GzipUtils.compress(data.value());
    }

    public static void compress(InputStream inputStream, OutputStream outputStream) throws IOException {
        try (BufferedInputStream bis = new BufferedInputStream(inputStream, 8192);
             BufferedOutputStream bos = new BufferedOutputStream(outputStream, 8192);
             GZIPOutputStream gzipOs = new GZIPOutputStream(bos);){
            int len;
            byte[] buffer = new byte[8192];
            while ((len = bis.read(buffer)) != -1) {
                gzipOs.write(buffer, 0, len);
            }
            gzipOs.finish();
        }
    }

    public static EasyData decompress(byte[] bytes) throws IOException {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
             GZIPInputStream gzipInputStream = new GZIPInputStream(byteArrayInputStream);){
            int len;
            byte[] buffer = new byte[8192];
            while ((len = gzipInputStream.read(buffer)) > 0) {
                byteArrayOutputStream.write(buffer, 0, len);
            }
        }
        return EasyData.of(byteArrayOutputStream.toByteArray());
    }

    public static EasyData decompress(String str) throws IOException {
        if (StringUtils.isEmpty(str)) {
            return null;
        }
        return GzipUtils.decompress(str.getBytes());
    }

    public static EasyData decompress(EasyData data) throws IOException {
        if (data == null) {
            return null;
        }
        return GzipUtils.decompress(data.value());
    }

    public static void decompress(InputStream inputStream, OutputStream outputStream) throws IOException {
        try (BufferedInputStream bis = new BufferedInputStream(inputStream, 8192);
             GZIPInputStream gzipOs = new GZIPInputStream(bis);
             BufferedOutputStream bos = new BufferedOutputStream(outputStream, 8192);){
            int len;
            byte[] buffer = new byte[8192];
            while ((len = gzipOs.read(buffer)) != -1) {
                bos.write(buffer, 0, len);
            }
        }
    }
}

