/*
 * Decompiled with CFR 0.152.
 */
package org.jiang.tools.decorator;

import java.util.function.Consumer;
import org.jiang.tools.decorator.BaseDecorator;
import org.jiang.tools.decorator.CodeSegment;

public class RunTimeDecorator
extends BaseDecorator<Long> {
    public RunTimeDecorator(CodeSegment codeSegment) {
        super(codeSegment);
    }

    @Override
    public Long run() {
        long startTime = System.currentTimeMillis();
        this.codeSegment.exec();
        long endTime = System.currentTimeMillis();
        return endTime - startTime;
    }

    public static Long run(CodeSegment codeSegment) {
        RunTimeDecorator decorator = new RunTimeDecorator(codeSegment);
        return decorator.run();
    }

    public static Long run(CodeSegment codeSegment, Consumer<Long> consumer) {
        RunTimeDecorator decorator = new RunTimeDecorator(codeSegment);
        Long time = decorator.run();
        consumer.accept(time);
        return time;
    }
}

