/*
 * Decompiled with CFR 0.152.
 */
package org.jiang.tools.geo;

public class CoordinateConverter {
    private static final double SEMIMAJOR_AXIS = 6378245.0;
    private static final double ECCENTRICITY_SQUARED = 0.006693421622965943;
    private static final double BD_PI = 52.35987755983;

    public static double[] wgs84ToGcj02(double lon, double lat) {
        return CoordinateConverter.convert(lon, lat, true);
    }

    public static double[] gcj02ToWgs84(double lon, double lat) {
        return CoordinateConverter.convert(lon, lat, false);
    }

    public static double[] gcj02ToBd09(double lon, double lat) {
        double z = Math.sqrt(lon * lon + lat * lat) + 2.0E-5 * Math.sin(lat * 52.35987755983);
        double theta = Math.atan2(lat, lon) + 3.0E-6 * Math.cos(lon * 52.35987755983);
        double bdLon = z * Math.cos(theta) + 0.0065;
        double bdLat = z * Math.sin(theta) + 0.006;
        return new double[]{bdLon, bdLat};
    }

    public static double[] bd09ToGcj02(double lon, double lat) {
        double x = lon - 0.0065;
        double y = lat - 0.006;
        double z = Math.sqrt(x * x + y * y) - 2.0E-5 * Math.sin(y * 52.35987755983);
        double theta = Math.atan2(y, x) - 3.0E-6 * Math.cos(x * 52.35987755983);
        double gcLon = z * Math.cos(theta);
        double gcLat = z * Math.sin(theta);
        return new double[]{gcLon, gcLat};
    }

    public static double[] wgs84ToBd09(double lon, double lat) {
        double[] gcj02 = CoordinateConverter.wgs84ToGcj02(lon, lat);
        return CoordinateConverter.gcj02ToBd09(gcj02[0], gcj02[1]);
    }

    public static double[] bd09ToWgs84(double lon, double lat) {
        double[] gcj02 = CoordinateConverter.bd09ToGcj02(lon, lat);
        return CoordinateConverter.gcj02ToWgs84(gcj02[0], gcj02[1]);
    }

    public static double[] toCartesian(double lon, double lat) {
        double x = lon * 2.003750834E7 / 180.0;
        double y = Math.log(Math.tan((90.0 + lat) * Math.PI / 360.0)) / (Math.PI / 180);
        y = y * 2.003750834E7 / 180.0;
        return new double[]{x, y};
    }

    private static double[] convert(double lon, double lat, boolean toGcj02) {
        double[] result = new double[2];
        if (CoordinateConverter.needToConvert(lon, lat)) {
            double dLon = CoordinateConverter.calculateLonOffset(lon - 105.0, lat - 35.0);
            double dLat = CoordinateConverter.calculateLatOffset(lon - 105.0, lat - 35.0);
            double radLat = lat / 180.0 * Math.PI;
            double magic = Math.sin(radLat);
            magic = 1.0 - 0.006693421622965943 * magic * magic;
            double sqrtMagic = Math.sqrt(magic);
            dLon = dLon * 180.0 / (6378245.0 / sqrtMagic * Math.cos(radLat) * Math.PI);
            dLat = dLat * 180.0 / (6335552.717000426 / (magic * sqrtMagic) * Math.PI);
            result[0] = toGcj02 ? lon + dLon : lon - dLon;
            result[1] = toGcj02 ? lat + dLat : lat - dLat;
        } else {
            result[0] = lon;
            result[1] = lat;
        }
        return result;
    }

    private static boolean needToConvert(double lon, double lat) {
        return CoordinateConverter.isInChina(lon, lat);
    }

    private static boolean isInChina(double lon, double lat) {
        return lon >= 72.004 && lon <= 137.8347 && lat >= 0.8293 && lat <= 55.8271;
    }

    private static double calculateLonOffset(double lon, double lat) {
        double ret = 300.0 + lon + 2.0 * lat + 0.1 * lon * lon + 0.1 * lon * lat + 0.1 * Math.sqrt(Math.abs(lon));
        ret += (20.0 * Math.sin(6.0 * lon * Math.PI) + 20.0 * Math.sin(2.0 * lon * Math.PI)) * 2.0 / 3.0;
        ret += (20.0 * Math.sin(lon * Math.PI) + 40.0 * Math.sin(lon / 3.0 * Math.PI)) * 2.0 / 3.0;
        return ret += (150.0 * Math.sin(lon / 12.0 * Math.PI) + 300.0 * Math.sin(lon / 30.0 * Math.PI)) * 2.0 / 3.0;
    }

    private static double calculateLatOffset(double lon, double lat) {
        double ret = -100.0 + 2.0 * lon + 3.0 * lat + 0.2 * lat * lat + 0.1 * lon * lat + 0.2 * Math.sqrt(Math.abs(lon));
        ret += (20.0 * Math.sin(6.0 * lon * Math.PI) + 20.0 * Math.sin(2.0 * lon * Math.PI)) * 2.0 / 3.0;
        ret += (20.0 * Math.sin(lat * Math.PI) + 40.0 * Math.sin(lat / 3.0 * Math.PI)) * 2.0 / 3.0;
        return ret += (160.0 * Math.sin(lat / 12.0 * Math.PI) + 320.0 * Math.sin(lat * Math.PI / 30.0)) * 2.0 / 3.0;
    }
}

