/*
 * Decompiled with CFR 0.152.
 */
package org.jiang.tools.lock;

import java.util.concurrent.atomic.AtomicInteger;
import org.jiang.tools.lock.Lock;

public class SpinFairLock
implements Lock {
    private final AtomicInteger currentNum = new AtomicInteger(0);
    private final AtomicInteger ticketNum = new AtomicInteger(0);
    private int count = 0;
    private static final ThreadLocal<Integer> threadLocalNum = new ThreadLocal();

    @Override
    public void lock() {
        Integer num = threadLocalNum.get();
        if (num != null && num.intValue() == this.currentNum.get()) {
            ++this.count;
            return;
        }
        num = this.getTicketNum();
        threadLocalNum.set(num);
        while (num.intValue() != this.currentNum.get()) {
            Thread.yield();
        }
    }

    @Override
    public void unlock() {
        Integer num = threadLocalNum.get();
        if (num.intValue() != this.currentNum.get()) {
            return;
        }
        if (this.count > 0) {
            --this.count;
            return;
        }
        threadLocalNum.remove();
        if (num == Integer.MAX_VALUE) {
            this.currentNum.set(0);
        } else {
            this.currentNum.set(num + 1);
        }
    }

    private int getTicketNum() {
        this.ticketNum.compareAndSet(Integer.MAX_VALUE, 0);
        return this.ticketNum.getAndIncrement();
    }
}

