/*
 * Decompiled with CFR 0.152.
 */
package org.jiang.tools.math;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import org.jiang.tools.exception.BadArgumentException;
import org.jiang.tools.math.RoundRule;

public class EasyNumber
implements Comparable<EasyNumber> {
    private static final String SYMBOL_ADD = "+";
    private static final String SYMBOL_SUBTRACT = "-";
    private static final String SYMBOL_MULTIPLY = "\u00d7";
    private static final String SYMBOL_DIVIDE = "\u00f7";
    private static final String SYMBOL_REMAINDER = "%";
    private static final String SYMBOL_POW = "^";
    private BigDecimal decimal;
    private BigDecimal remainedDecimal;
    private RoundRule roundRule = RoundRule.down(2);
    private StringBuilder courseString;
    private int leftBracketIndex = -1;

    private EasyNumber(BigDecimal decimal) {
        this.decimal = decimal;
    }

    public static EasyNumber zero() {
        return EasyNumber.of(0L);
    }

    public static EasyNumber of(long number) {
        return EasyNumber.of(BigDecimal.valueOf(number));
    }

    public static EasyNumber of(double number) {
        return EasyNumber.of(BigDecimal.valueOf(number));
    }

    public static EasyNumber of(String number) {
        return EasyNumber.of(BigDecimal.valueOf(Double.parseDouble(number)));
    }

    public static EasyNumber of(BigInteger number) {
        return EasyNumber.of(new BigDecimal(number));
    }

    public static EasyNumber of(BigDecimal number) {
        return new EasyNumber(number);
    }

    public static EasyNumber ofHexString(String hexString) {
        return EasyNumber.of(Long.parseLong(hexString, 16));
    }

    public static EasyNumber ofDoubleHexString(String doubleHexString) {
        long longBits = Long.parseLong(doubleHexString, 16);
        return EasyNumber.of(Double.longBitsToDouble(longBits));
    }

    public EasyNumber rule(RoundRule roundRule) {
        this.roundRule = roundRule;
        return this;
    }

    public EasyNumber integerRule() {
        this.roundRule = RoundRule.down(0);
        return this;
    }

    public BigDecimal value() {
        return this.decimal.setScale(this.roundRule.getScale(), this.roundRule.getMode());
    }

    public int toInt() {
        return this.value().intValue();
    }

    public long toLong() {
        return this.value().longValue();
    }

    public float toFloat() {
        return this.value().floatValue();
    }

    public double toDouble() {
        return this.value().doubleValue();
    }

    public String toString() {
        return this.value().toString();
    }

    public String toFormatString() {
        NumberFormat numberFormat = NumberFormat.getInstance();
        return numberFormat.format(this.value());
    }

    public String course() {
        if (this.courseString == null) {
            return this.toString();
        }
        StringBuilder result = new StringBuilder(this.courseString);
        result.append("=");
        result.append(this);
        if (this.remainedDecimal != null && this.remainedDecimal.doubleValue() > 0.0) {
            result.append("(");
            result.append("~");
            result.append(this.remainder());
            result.append(")");
        }
        return result.toString();
    }

    public BigDecimal remainder() {
        if (this.remainedDecimal == null) {
            throw new BadArgumentException("\u6ca1\u6709\u9884\u5148\u7684\u9664\u6cd5\u8fd0\u7b97");
        }
        return this.remainedDecimal.setScale(this.roundRule.getScale(), this.roundRule.getMode());
    }

    public int signum() {
        return this.decimal.signum();
    }

    public String toHexString() {
        return Long.toHexString(this.toLong());
    }

    public String toDoubleHexString() {
        long longBits = Double.doubleToLongBits(this.decimal.doubleValue());
        return Long.toHexString(longBits);
    }

    public EasyNumber add(long number) {
        return this.add(EasyNumber.of(number));
    }

    public EasyNumber add(double number) {
        return this.add(EasyNumber.of(number));
    }

    public EasyNumber add(BigInteger number) {
        return this.add(EasyNumber.of(number));
    }

    public EasyNumber add(BigDecimal number) {
        return this.add(EasyNumber.of(number));
    }

    public EasyNumber subtract(long number) {
        return this.subtract(EasyNumber.of(number));
    }

    public EasyNumber subtract(double number) {
        return this.subtract(EasyNumber.of(number));
    }

    public EasyNumber subtract(BigInteger number) {
        return this.subtract(EasyNumber.of(number));
    }

    public EasyNumber subtract(BigDecimal number) {
        return this.subtract(EasyNumber.of(number));
    }

    public EasyNumber multiply(long number) {
        return this.multiply(EasyNumber.of(number));
    }

    public EasyNumber multiply(double number) {
        return this.multiply(EasyNumber.of(number));
    }

    public EasyNumber multiply(BigInteger number) {
        return this.multiply(EasyNumber.of(number));
    }

    public EasyNumber multiply(BigDecimal number) {
        return this.multiply(EasyNumber.of(number));
    }

    public EasyNumber divide(long number) {
        return this.divide(EasyNumber.of(number));
    }

    public EasyNumber divide(double number) {
        return this.divide(EasyNumber.of(number));
    }

    public EasyNumber divide(BigInteger number) {
        return this.divide(EasyNumber.of(number));
    }

    public EasyNumber divide(BigDecimal number) {
        return this.divide(EasyNumber.of(number));
    }

    public EasyNumber remainder(long number) {
        return this.remainder(EasyNumber.of(number));
    }

    public EasyNumber remainder(double number) {
        return this.remainder(EasyNumber.of(number));
    }

    public EasyNumber remainder(BigInteger number) {
        return this.remainder(EasyNumber.of(number));
    }

    public EasyNumber remainder(BigDecimal number) {
        return this.remainder(EasyNumber.of(number));
    }

    public EasyNumber max(long number) {
        return this.max(EasyNumber.of(number));
    }

    public EasyNumber max(double number) {
        return this.max(EasyNumber.of(number));
    }

    public EasyNumber max(BigInteger number) {
        return this.max(EasyNumber.of(number));
    }

    public EasyNumber max(BigDecimal number) {
        return this.max(EasyNumber.of(number));
    }

    public EasyNumber min(long number) {
        return this.min(EasyNumber.of(number));
    }

    public EasyNumber min(double number) {
        return this.min(EasyNumber.of(number));
    }

    public EasyNumber min(BigInteger number) {
        return this.min(EasyNumber.of(number));
    }

    public EasyNumber min(BigDecimal number) {
        return this.min(EasyNumber.of(number));
    }

    public EasyNumber add(EasyNumber number) {
        this.addCourse(SYMBOL_ADD, number);
        this.decimal = this.decimal.add(number.value());
        this.remainedDecimal = null;
        return this;
    }

    public EasyNumber subtract(EasyNumber number) {
        this.addCourse(SYMBOL_SUBTRACT, number);
        this.decimal = this.decimal.subtract(number.value());
        this.remainedDecimal = null;
        return this;
    }

    public EasyNumber multiply(EasyNumber number) {
        this.addCourse(SYMBOL_MULTIPLY, number);
        this.decimal = this.decimal.multiply(number.value());
        this.remainedDecimal = null;
        return this;
    }

    public EasyNumber divide(EasyNumber number) {
        BigDecimal numberDecimal = number.value();
        this.remainedDecimal = this.decimal.remainder(numberDecimal);
        this.addCourse(SYMBOL_DIVIDE, number);
        this.decimal = this.decimal.divide(numberDecimal, this.roundRule.getScale(), this.roundRule.getMode());
        return this;
    }

    public EasyNumber remainder(EasyNumber number) {
        this.addCourse(SYMBOL_REMAINDER, number);
        this.decimal = this.decimal.remainder(number.value());
        this.remainedDecimal = null;
        return this;
    }

    public EasyNumber max(EasyNumber number) {
        switch (this.compareTo(number)) {
            case -1: {
                return number;
            }
            case 0: 
            case 1: {
                return this;
            }
        }
        return this;
    }

    public EasyNumber min(EasyNumber number) {
        switch (this.compareTo(number)) {
            case -1: 
            case 0: {
                return this;
            }
            case 1: {
                return number;
            }
        }
        return this;
    }

    public EasyNumber pow(int number) {
        this.addCourse(SYMBOL_POW, EasyNumber.of(number).integerRule());
        this.decimal = this.decimal.pow(number);
        this.remainedDecimal = null;
        return this;
    }

    private void addCourse(String symbol, EasyNumber number) {
        String str;
        boolean isAddSubtract = SYMBOL_ADD.equals(symbol) || SYMBOL_SUBTRACT.equals(symbol);
        String string = str = number.courseString != null ? String.format("(%s)", number.courseString) : number.value().setScale(this.roundRule.getScale(), this.roundRule.getMode()).toString();
        if (isAddSubtract && this.leftBracketIndex == -1) {
            this.leftBracketIndex = 0;
        }
        if (this.courseString == null) {
            this.courseString = new StringBuilder(this.toString());
        }
        if (!isAddSubtract && this.leftBracketIndex > -1) {
            this.courseString.insert(this.leftBracketIndex, "(");
            this.courseString.append(")");
            this.leftBracketIndex = -1;
        }
        this.courseString.append(symbol);
        this.courseString.append(str);
    }

    @Override
    public int compareTo(EasyNumber o) {
        return this.decimal.compareTo(o.decimal);
    }

    public boolean equals(Object obj) {
        double value;
        if (obj == null) {
            return false;
        }
        if (obj instanceof Integer) {
            value = ((Integer)obj).intValue();
        } else if (obj instanceof Long) {
            value = ((Long)obj).longValue();
        } else if (obj instanceof Float) {
            value = ((Float)obj).floatValue();
        } else if (obj instanceof Double) {
            value = (Double)obj;
        } else if (obj instanceof String) {
            value = Double.parseDouble((String)obj);
        } else if (obj instanceof BigInteger) {
            value = ((BigInteger)obj).doubleValue();
        } else if (obj instanceof BigDecimal) {
            value = ((BigDecimal)obj).doubleValue();
        } else if (obj instanceof EasyNumber) {
            value = ((EasyNumber)obj).toDouble();
        } else {
            return false;
        }
        return this.toDouble() == value;
    }
}

