/*
 * Decompiled with CFR 0.152.
 */
package org.jiang.tools.test;

import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jiang.tools.collection.CollectionUtils;
import org.jiang.tools.text.StringUtils;

public class Assert {
    public static <T> AssertResult<T> notNull(T obj) {
        return AssertResult.build(obj, obj != null);
    }

    public static <T> AssertResult<T> isNull(T obj) {
        return AssertResult.build(obj, obj == null);
    }

    public static <T extends CharSequence> AssertResult<T> notEmpty(T obj) {
        return AssertResult.build(obj, StringUtils.notEmpty(obj));
    }

    public static <T extends CharSequence> AssertResult<T> isEmpty(T obj) {
        return AssertResult.build(obj, StringUtils.isEmpty(obj));
    }

    public static <T extends Collection<?>> AssertResult<T> notEmpty(T obj) {
        return AssertResult.build(obj, CollectionUtils.notEmpty(obj));
    }

    public static <T extends Collection<?>> AssertResult<T> isEmpty(T obj) {
        return AssertResult.build(obj, CollectionUtils.isEmpty(obj));
    }

    public static <T> AssertResult<T> equals(T obj, T target) {
        if (obj == null) {
            return AssertResult.build(null, target == null);
        }
        return AssertResult.build(obj, obj.equals(target));
    }

    public static <T> AssertResult<T> notEquals(T obj, T target) {
        if (obj == null) {
            return AssertResult.build(null, target != null);
        }
        return AssertResult.build(obj, !obj.equals(target));
    }

    public static AssertResult<Boolean> apply(boolean isTrue) {
        return AssertResult.build(isTrue, isTrue);
    }

    public static <T> AssertResult<T> apply(T obj, boolean isTrue) {
        return AssertResult.build(obj, isTrue);
    }

    public static <T> AssertResult<T> apply(T obj, Function<T, Boolean> function) {
        return AssertResult.build(obj, function.apply(obj));
    }

    public static class AssertResult<T> {
        private T obj;
        private boolean isTrue;

        public static <T> AssertResult<T> build(T t, boolean isTrue) {
            AssertResult<T> assertResult = new AssertResult<T>();
            assertResult.obj = t;
            assertResult.isTrue = isTrue;
            return assertResult;
        }

        public T or(T t) {
            if (this.isTrue) {
                return this.obj;
            }
            return t;
        }

        public T or(Supplier<T> supplier) {
            if (this.isTrue) {
                return this.obj;
            }
            return supplier.get();
        }

        public T orThrow(RuntimeException e) throws RuntimeException {
            if (this.isTrue) {
                return this.obj;
            }
            throw e;
        }

        public T orThrow(Supplier<RuntimeException> supplier) throws RuntimeException {
            if (this.isTrue) {
                return this.obj;
            }
            throw supplier.get();
        }

        public T orThrow(Function<String, RuntimeException> function, String message) throws RuntimeException {
            if (this.isTrue) {
                return this.obj;
            }
            throw function.apply(message);
        }

        public boolean isTrue() {
            return this.isTrue;
        }

        public AssertResult<T> isTrue(Consumer<T> consumer) {
            if (!this.isTrue) {
                return this;
            }
            consumer.accept(this.obj);
            return this;
        }
    }
}

