/*
 * Decompiled with CFR 0.152.
 */
package org.jiang.tools.text;

import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jiang.tools.json.JsonUtils;
import org.jiang.tools.object.EasyResolver;

public class TemplateParser {
    private static final String REGEX_ESCAPE_CHARS = "$()*+.[]?\\^{}|";
    public static final String EXP_START_DEFAULT = "${";
    public static final String EXP_END_DEFAULT = "}";
    private final String expStart;
    private final String expEnd;
    private final String expPlaceholder;

    public TemplateParser() {
        this(EXP_START_DEFAULT, EXP_END_DEFAULT);
    }

    protected TemplateParser(String expStart, String expEnd) {
        this.expStart = expStart;
        this.expEnd = expEnd;
        this.expPlaceholder = "(?<=" + this.regexEscape(expStart) + ").*?(?=" + this.regexEscape(expEnd) + ")";
    }

    public String format(String template, Object obj) {
        Object value;
        EasyResolver easyResolver = EasyResolver.of(obj);
        Matcher matcher = Pattern.compile(this.expPlaceholder).matcher(template);
        HashMap<String, String> matched = new HashMap<String, String>(4);
        while (matcher.find()) {
            String exp = matcher.group();
            String fullExp = this.expStart + exp + this.expEnd;
            if (matched.containsKey(fullExp)) continue;
            value = easyResolver.get(exp);
            String strValue = this.objectToString(value);
            matched.put(fullExp, strValue);
        }
        for (String key : matched.keySet()) {
            value = (String)matched.get(key);
            template = template.replace(key, (CharSequence)value);
        }
        return template;
    }

    private String objectToString(Object obj) {
        if (obj == null) {
            return "null";
        }
        Class<Number> cls = obj.getClass();
        if (cls.isPrimitive()) {
            return obj.toString();
        }
        if (cls.isAssignableFrom(Number.class)) {
            return obj.toString();
        }
        if (obj instanceof CharSequence) {
            return obj.toString();
        }
        return JsonUtils.toJson(obj);
    }

    private String regexEscape(String str) {
        char[] cs;
        StringBuilder result = new StringBuilder();
        for (char c : cs = str.toCharArray()) {
            if (REGEX_ESCAPE_CHARS.indexOf(c) == -1) continue;
            result.append("\\");
            result.append(c);
        }
        return result.toString();
    }
}

