/*
 * Decompiled with CFR 0.152.
 */
package org.jiang.tools.arithmetic.hash;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jiang.tools.arithmetic.hash.ConsistentHashLoop;
import org.jiang.tools.arithmetic.hash.ConsistentHashNode;
import org.jiang.tools.arithmetic.hash.PointScope;
import org.jiang.tools.exception.BadArgumentException;

public class ConsistentHash {
    private final ConsistentHashLoop consistentHashLoop;

    private ConsistentHash(ConsistentHashLoop consistentHashLoop) {
        this.consistentHashLoop = consistentHashLoop;
    }

    public static ConsistentHash of(ConsistentHashLoop consistentHashLoop) {
        return new ConsistentHash(consistentHashLoop);
    }

    public ConsistentHashNode getNode(Object obj) {
        return this.getNode(this.consistentHashLoop.hashPoint(obj));
    }

    public ConsistentHashNode getNode(Integer point) {
        TreeMap<Integer, ConsistentHashNode> nodes = this.consistentHashLoop.getNodes();
        if (nodes.isEmpty()) {
            return null;
        }
        Map.Entry<Integer, ConsistentHashNode> entry = nodes.ceilingEntry(point);
        return entry != null ? entry.getValue() : nodes.firstEntry().getValue();
    }

    public PointScope[] putNode(ConsistentHashNode node) {
        if (node.getPoint() == null) {
            throw new BadArgumentException("node point can't be null");
        }
        this.consistentHashLoop.addNode(node);
        TreeSet<Integer> points = new TreeSet<Integer>();
        points.add(node.getPoint());
        points.addAll(Arrays.asList(node.getVirtualPoints()));
        if (this.consistentHashLoop.getNodes().size() == points.size()) {
            return new PointScope[0];
        }
        TreeMap<Integer, PointScope> pointScopeMap = new TreeMap<Integer, PointScope>();
        for (Integer point : points) {
            PointScope pointScope = this.getPointScope(point);
            if (pointScope == null) continue;
            pointScopeMap.put(point, pointScope);
        }
        return pointScopeMap.values().toArray(new PointScope[0]);
    }

    public PointScope[] removeNode(ConsistentHashNode node) {
        return this.removeNode(node.getPoint());
    }

    public PointScope[] removeNode(int point) {
        TreeMap<Integer, ConsistentHashNode> nodes = this.consistentHashLoop.getNodes();
        ConsistentHashNode node = nodes.get(point);
        if (node == null) {
            return null;
        }
        this.consistentHashLoop.getRealNodes().remove(node);
        TreeSet<Integer> list = new TreeSet<Integer>();
        list.add(node.getPoint());
        list.addAll(Arrays.asList(node.getVirtualPoints()));
        list.forEach(nodes::remove);
        HashMap<Integer, PointScope> pointScopeMap = new HashMap<Integer, PointScope>(list.size());
        HashMap<Integer, List> nextNodeMap = new HashMap<Integer, List>(list.size());
        for (Integer endPoint : list) {
            PointScope pointScope = this.getPointScope(endPoint);
            if (pointScope == null) continue;
            pointScopeMap.put(endPoint, pointScope);
            if (pointScope.getNextNode() == null) continue;
            nextNodeMap.computeIfAbsent(pointScope.getNextNodePoint(), obj -> new ArrayList()).add(endPoint);
        }
        if (pointScopeMap.size() <= 1) {
            return pointScopeMap.values().toArray(new PointScope[0]);
        }
        ArrayList<Object> result = new ArrayList<Object>(nextNodeMap.size());
        for (Map.Entry entry : nextNodeMap.entrySet()) {
            Integer nextNodePoint = (Integer)entry.getKey();
            List nodeList = (List)entry.getValue();
            if (nodeList.size() == 1) {
                result.add(pointScopeMap.get(nodeList.get(0)));
                continue;
            }
            Integer longestPoint = this.geLongestDistance(nodeList, nextNodePoint);
            Integer shortestPoint = this.geShortestDistance(nodeList, nextNodePoint);
            PointScope pointScope = (PointScope)pointScopeMap.get(longestPoint);
            pointScope.setEnd(shortestPoint);
            result.add(pointScope);
        }
        return result.toArray(new PointScope[0]);
    }

    public PointScope getPointScope(ConsistentHashNode endNode) {
        return this.getPointScope(endNode.getPoint());
    }

    public PointScope getPointScope(Integer endPoint) {
        TreeMap<Integer, ConsistentHashNode> nodes = this.consistentHashLoop.getNodes();
        if (nodes.isEmpty()) {
            return null;
        }
        Map.Entry<Integer, ConsistentHashNode> entry = nodes.lowerEntry(endPoint);
        Integer startPoint = entry != null ? entry.getKey() : nodes.lastEntry().getKey();
        return this.getPointScope(startPoint, endPoint);
    }

    public PointScope getPointScope(Integer startPoint, Integer endPoint) {
        Integer pointCount;
        if (startPoint.equals(endPoint)) {
            return null;
        }
        ConsistentHashNode nextNode = null;
        Integer nextNodePoint = null;
        TreeMap<Integer, ConsistentHashNode> nodes = this.consistentHashLoop.getNodes();
        if (!nodes.isEmpty()) {
            Map.Entry<Integer, ConsistentHashNode> entry = nodes.ceilingEntry(endPoint);
            if (entry == null) {
                entry = nodes.firstEntry();
            }
            nextNodePoint = entry.getKey();
            nextNode = entry.getValue();
        }
        startPoint = startPoint.equals(pointCount = this.getConsistentHashLoop().getPointCount()) ? pointCount : startPoint + 1;
        return new PointScope(startPoint, endPoint, nextNode, nextNodePoint, this.consistentHashLoop);
    }

    private int getTargetDistance(int point, int target) {
        if (point <= target) {
            return target - point;
        }
        return this.consistentHashLoop.getPointCount() - target + point;
    }

    private Integer geLongestDistance(List<Integer> points, int target) {
        Integer result = null;
        int longest = 0;
        for (Integer point : points) {
            int distance = this.getTargetDistance(point, target);
            if (result != null && distance <= longest) continue;
            result = point;
            longest = distance;
        }
        return result;
    }

    private Integer geShortestDistance(List<Integer> points, int target) {
        Integer result = null;
        int longest = 0;
        for (Integer point : points) {
            int distance = this.getTargetDistance(point, target);
            if (result != null && distance >= longest) continue;
            result = point;
            longest = distance;
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        int start = 0;
        for (Map.Entry<Integer, ConsistentHashNode> entry : this.consistentHashLoop.getNodes().entrySet()) {
            ConsistentHashNode node = entry.getValue();
            sb.append(" ");
            sb.append(start);
            sb.append("...");
            sb.append(entry.getKey());
            sb.append(" = ");
            sb.append(node.getTarget());
            if (!entry.getKey().equals(node.getPoint())) {
                sb.append("(virtual)");
            }
            sb.append(" |");
            start = entry.getKey() + 1;
        }
        if (sb.length() > 1) {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append("]");
        return sb.toString();
    }

    public ConsistentHashLoop getConsistentHashLoop() {
        return this.consistentHashLoop;
    }
}

