/*
 * Decompiled with CFR 0.152.
 */
package org.jiang.tools.arithmetic.hash;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.TreeMap;
import org.jiang.tools.arithmetic.hash.ConsistentHashNode;
import org.jiang.tools.exception.BadArgumentException;
import org.jiang.tools.text.RandomUtils;

public class ConsistentHashLoop
implements Serializable {
    private Integer pointCount;
    private transient TreeMap<Integer, ConsistentHashNode> nodes;
    private List<ConsistentHashNode> realNodes;

    public ConsistentHashLoop() {
        this.init();
    }

    public ConsistentHashLoop(Integer pointCount) {
        this();
        this.pointCount = pointCount;
    }

    private void init() {
        this.nodes = this.nodes != null ? this.nodes : new TreeMap();
        this.realNodes = this.realNodes != null ? this.realNodes : new ArrayList<ConsistentHashNode>();
    }

    public void setPointCount(Integer pointCount) {
        if (this.pointCount != null) {
            throw new BadArgumentException("point count can not be changed");
        }
        this.pointCount = pointCount;
    }

    public void setRealNodes(List<ConsistentHashNode> realNodes) {
        this.nodes = new TreeMap();
        this.realNodes = new ArrayList<ConsistentHashNode>(realNodes.size());
        for (ConsistentHashNode realNode : realNodes) {
            this.createNode(realNode.getPoint(), realNode.getTarget(), realNode.getVirtualPoints());
        }
    }

    public int addNode(ConsistentHashNode node) {
        this.realNodes.add(node);
        this.nodes.put(node.getPoint(), node);
        if (node.getVirtualPoints() == null) {
            return 1;
        }
        for (Integer virtualPoint : node.getVirtualPoints()) {
            this.nodes.put(virtualPoint, node);
        }
        return node.getVirtualPoints().length + 1;
    }

    public ConsistentHashNode createNode(Object target) {
        return this.createNode((Integer)this.generateNodePoint(target), target, 0);
    }

    public ConsistentHashNode createNode(Integer point, Object target) {
        return this.createNode(point, target, 0);
    }

    public ConsistentHashNode createNode(Object target, Integer virtualCount) {
        return this.createNode((Integer)this.generateNodePoint(target), target, virtualCount);
    }

    public ConsistentHashNode createNode(Integer point, Object target, Integer virtualCount) {
        HashSet<Integer> virtualPoints = new HashSet<Integer>(virtualCount);
        for (int i = 0; i < virtualCount; ++i) {
            StringBuilder sb = new StringBuilder(point);
            sb.append("#");
            sb.append(RandomUtils.generate(6));
            int virtualPoint = this.generateNodePoint(sb);
            if (point == virtualPoint || virtualPoints.contains(virtualPoint)) {
                --i;
                continue;
            }
            virtualPoints.add(virtualPoint);
        }
        return this.createNode(point, target, virtualPoints.toArray(new Integer[0]));
    }

    public ConsistentHashNode createNode(Integer point, Object target, Integer[] virtualPoints) {
        if (point == null) {
            throw new BadArgumentException("node point can't be null");
        }
        return new ConsistentHashNode(point, target, virtualPoints);
    }

    private int generateNodePoint(Object obj) {
        int point;
        String offset = null;
        do {
            point = this.hashPoint(obj, offset);
            offset = RandomUtils.generate(6);
        } while (this.nodes.containsKey(point));
        return point;
    }

    public int hashPoint(Object ... objs) {
        if (objs.length == 0) {
            throw new BadArgumentException("objects can't be empty");
        }
        return Math.abs(Objects.hash(objs) % this.getPointCount());
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        List<ConsistentHashNode> realNodes = this.realNodes;
        this.realNodes = null;
        this.init();
        realNodes.forEach(this::addNode);
    }

    public Integer getPointCount() {
        return this.pointCount;
    }

    public TreeMap<Integer, ConsistentHashNode> getNodes() {
        return this.nodes;
    }

    public List<ConsistentHashNode> getRealNodes() {
        return this.realNodes;
    }
}

