/*
 * Decompiled with CFR 0.152.
 */
package org.jiang.tools.arithmetic.hash;

import java.util.ArrayList;
import org.jiang.tools.arithmetic.hash.ConsistentHashLoop;
import org.jiang.tools.arithmetic.hash.ConsistentHashNode;

public class PointScope {
    private Integer start;
    private Integer end;
    private final ConsistentHashNode nextNode;
    private final Integer nextNodePoint;
    private final ConsistentHashLoop loop;

    public boolean contains(Integer point) {
        if (this.start <= this.end) {
            return point >= this.start && point <= this.end;
        }
        return point > this.start || point < this.end;
    }

    public Integer[] filtration(Integer ... points) {
        ArrayList<Integer> containsList = new ArrayList<Integer>();
        for (Integer point : points) {
            if (!this.contains(point)) continue;
            containsList.add(point);
        }
        return containsList.toArray(new Integer[0]);
    }

    public Object[] filtration(Object ... objs) {
        ArrayList<Object> containsList = new ArrayList<Object>();
        for (Object obj : objs) {
            if (!this.contains(this.loop.hashPoint(obj))) continue;
            containsList.add(obj);
        }
        return containsList.toArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append("(start=");
        sb.append(this.start);
        sb.append(", end=");
        sb.append(this.end);
        if (this.nextNode != null) {
            sb.append(", next=");
            sb.append(this.nextNode.getTarget());
        }
        sb.append(")");
        return sb.toString();
    }

    public Integer getStart() {
        return this.start;
    }

    public Integer getEnd() {
        return this.end;
    }

    public ConsistentHashNode getNextNode() {
        return this.nextNode;
    }

    public Integer getNextNodePoint() {
        return this.nextNodePoint;
    }

    public ConsistentHashLoop getLoop() {
        return this.loop;
    }

    public void setStart(Integer start) {
        this.start = start;
    }

    public void setEnd(Integer end) {
        this.end = end;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PointScope)) {
            return false;
        }
        PointScope other = (PointScope)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$start = this.getStart();
        Integer other$start = other.getStart();
        if (this$start == null ? other$start != null : !((Object)this$start).equals(other$start)) {
            return false;
        }
        Integer this$end = this.getEnd();
        Integer other$end = other.getEnd();
        if (this$end == null ? other$end != null : !((Object)this$end).equals(other$end)) {
            return false;
        }
        Integer this$nextNodePoint = this.getNextNodePoint();
        Integer other$nextNodePoint = other.getNextNodePoint();
        if (this$nextNodePoint == null ? other$nextNodePoint != null : !((Object)this$nextNodePoint).equals(other$nextNodePoint)) {
            return false;
        }
        ConsistentHashNode this$nextNode = this.getNextNode();
        ConsistentHashNode other$nextNode = other.getNextNode();
        if (this$nextNode == null ? other$nextNode != null : !((Object)this$nextNode).equals(other$nextNode)) {
            return false;
        }
        ConsistentHashLoop this$loop = this.getLoop();
        ConsistentHashLoop other$loop = other.getLoop();
        return !(this$loop == null ? other$loop != null : !this$loop.equals(other$loop));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PointScope;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $start = this.getStart();
        result = result * 59 + ($start == null ? 43 : ((Object)$start).hashCode());
        Integer $end = this.getEnd();
        result = result * 59 + ($end == null ? 43 : ((Object)$end).hashCode());
        Integer $nextNodePoint = this.getNextNodePoint();
        result = result * 59 + ($nextNodePoint == null ? 43 : ((Object)$nextNodePoint).hashCode());
        ConsistentHashNode $nextNode = this.getNextNode();
        result = result * 59 + ($nextNode == null ? 43 : ((Object)$nextNode).hashCode());
        ConsistentHashLoop $loop = this.getLoop();
        result = result * 59 + ($loop == null ? 43 : $loop.hashCode());
        return result;
    }

    public PointScope(Integer start, Integer end, ConsistentHashNode nextNode, Integer nextNodePoint, ConsistentHashLoop loop) {
        this.start = start;
        this.end = end;
        this.nextNode = nextNode;
        this.nextNodePoint = nextNodePoint;
        this.loop = loop;
    }
}

