/*
 * Decompiled with CFR 0.152.
 */
package org.jiang.tools.canvas;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import org.jiang.tools.canvas.EasyCanvas;
import org.jiang.tools.canvas.element.EasyElement;
import org.jiang.tools.canvas.element.EasyImage;
import org.jiang.tools.canvas.element.EasyLine;
import org.jiang.tools.canvas.element.EasyRect;
import org.jiang.tools.canvas.element.EasyText;
import org.jiang.tools.canvas.element.EasyTextArea;
import org.jiang.tools.canvas.image.ImageDrawPosition;
import org.jiang.tools.canvas.image.ImageModeUtils;
import org.jiang.tools.exception.SystemException;

public final class EasyCanvasUtils {
    public static BufferedImage write(EasyCanvas easyCanvas) {
        BufferedImage bufferedImage = new BufferedImage(easyCanvas.getWidth(), easyCanvas.getHeight(), 1);
        EasyRect backgroundRect = EasyRect.buildFill(0, 0, easyCanvas.getWidth(), easyCanvas.getHeight(), easyCanvas.getBackgroundColor());
        EasyCanvasUtils.drawRect(bufferedImage, backgroundRect);
        for (EasyElement element : easyCanvas.getElements()) {
            bufferedImage = EasyCanvasUtils.draw(bufferedImage, element);
        }
        return bufferedImage;
    }

    public static void write(EasyCanvas easyCanvas, OutputStream outputStream, String formatName) throws IOException {
        BufferedImage bufferedImage = EasyCanvasUtils.write(easyCanvas);
        ImageIO.write((RenderedImage)bufferedImage, formatName, outputStream);
    }

    public static void write(EasyCanvas easyCanvas, File file, String formatName) throws IOException {
        FileOutputStream outputStream = new FileOutputStream(file);
        EasyCanvasUtils.write(easyCanvas, outputStream, formatName);
    }

    public static BufferedImage draw(BufferedImage bufferedImage, EasyElement element) {
        BufferedImage result;
        if (element instanceof EasyImage) {
            result = EasyCanvasUtils.drawImage(bufferedImage, (EasyImage)element);
        } else if (element instanceof EasyText) {
            result = EasyCanvasUtils.drawText(bufferedImage, (EasyText)element);
        } else if (element instanceof EasyRect) {
            result = EasyCanvasUtils.drawRect(bufferedImage, (EasyRect)element);
        } else if (element instanceof EasyLine) {
            result = EasyCanvasUtils.drawLine(bufferedImage, (EasyLine)element);
        } else {
            throw new SystemException("element type is unanticipated");
        }
        return result;
    }

    private static BufferedImage drawImage(BufferedImage bufferedImage, EasyImage element) {
        if (element.getImage() == null) {
            throw new SystemException("element image is null");
        }
        ImageDrawPosition position = ImageModeUtils.fit(element);
        Graphics2D graphics = bufferedImage.createGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.drawImage(element.getImage(), position.getStartX(), position.getStartY(), position.getEndX(), position.getEndY(), position.getClipStartX(), position.getClipStartY(), position.getClipEndX(), position.getClipEndY(), null);
        return bufferedImage;
    }

    private static BufferedImage drawText(BufferedImage bufferedImage, EasyText element) {
        String content;
        Graphics2D graphics = bufferedImage.createGraphics();
        graphics.setColor(element.getColor());
        Font font = element.getFont().toFont();
        graphics.setFont(font);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        String string = content = element.getContent() != null ? element.getContent() : "";
        if (element instanceof EasyTextArea) {
            EasyTextArea textArea = (EasyTextArea)element;
            char[] chars = content.toCharArray();
            int lineHeight = (int)((double)textArea.getFont().getSize() * 1.5);
            StringBuilder line = new StringBuilder();
            ArrayList<StringBuilder> lines = new ArrayList<StringBuilder>();
            lines.add(line);
            for (char c : chars) {
                line.append(c);
                int textWidth = graphics.getFontMetrics().stringWidth(line.toString());
                if (textWidth <= textArea.getWidth()) continue;
                line.deleteCharAt(line.length() - 1);
                if ((lines.size() + 1) * lineHeight > textArea.getHeight()) {
                    line.delete(line.length() - 3, line.length());
                    line.append("...");
                    break;
                }
                line = new StringBuilder();
                line.append(c);
                lines.add(line);
            }
            for (int i = 0; i < lines.size(); ++i) {
                int textWidth = graphics.getFontMetrics().stringWidth(line.toString());
                int x = textArea.getX();
                switch (textArea.getAlign()) {
                    case 1: {
                        x = (textArea.getWidth() - textWidth) / 2;
                        break;
                    }
                    case 2: {
                        x = textArea.getWidth() - textWidth;
                        break;
                    }
                }
                graphics.drawString(((StringBuilder)lines.get(i)).toString(), x, textArea.getY() + i * lineHeight + element.getFont().getSize());
            }
        } else {
            graphics.drawString(content, element.getX(), element.getY() + element.getFont().getSize());
        }
        return bufferedImage;
    }

    private static BufferedImage drawRect(BufferedImage bufferedImage, EasyRect element) {
        Graphics2D graphics = bufferedImage.createGraphics();
        graphics.setColor(element.getColor());
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (element.getMode() == 1) {
            graphics.drawRect(element.getX(), element.getY(), element.getWidth(), element.getHeight());
        } else {
            graphics.fillRect(element.getX(), element.getY(), element.getWidth(), element.getHeight());
        }
        return bufferedImage;
    }

    private static BufferedImage drawLine(BufferedImage bufferedImage, EasyLine element) {
        Graphics2D graphics = bufferedImage.createGraphics();
        graphics.setColor(element.getColor());
        graphics.drawLine(element.getX(), element.getY(), element.getEx(), element.getEy());
        return bufferedImage;
    }
}

