/*
 * Decompiled with CFR 0.152.
 */
package org.jiang.tools.collection;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class CollectionUtils {
    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean notEmpty(Collection<?> collection) {
        return !CollectionUtils.isEmpty(collection);
    }

    public static <T> T getFirstElement(Collection<T> collection) {
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        if (collection instanceof List) {
            List list = (List)collection;
            return (T)list.get(0);
        }
        return collection.iterator().next();
    }

    public static <T> T getLastElement(Collection<T> collection) {
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        if (collection instanceof List) {
            List list = (List)collection;
            return (T)list.get(list.size() - 1);
        }
        Iterator<T> iterator = collection.iterator();
        T lastElement = null;
        while (iterator.hasNext()) {
            lastElement = iterator.next();
        }
        return lastElement;
    }

    public static <T> T getElement(Collection<T> collection, int index) {
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        if (collection instanceof List) {
            List list = (List)collection;
            return (T)list.get(index);
        }
        Iterator<T> iterator = collection.iterator();
        int currentIndex = 0;
        while (iterator.hasNext()) {
            T element = iterator.next();
            if (currentIndex == index) {
                return element;
            }
            ++currentIndex;
        }
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + collection.size());
    }
}

