/*
 * Decompiled with CFR 0.152.
 */
package org.jiang.tools.collection.list;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ThreadLocalRandom;

public class SkipList<E extends Comparable<E>>
implements Collection<E>,
Cloneable,
Serializable {
    public static final byte MAX_INDEX_LEVEL = 32;
    private int p = 50;
    private int size = 0;
    private int indexLevel = 0;
    private Node<E> header = new Node<Object>(null, null, null);
    private Node<E> first;
    private Node<E> last;

    public SkipList() {
    }

    public SkipList(int p) {
        this();
        this.p = p;
    }

    public SkipList(Collection<E> collection) {
        this();
        this.addAll(collection);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object o) {
        if (!(o instanceof Comparable) || this.isEmpty()) {
            return false;
        }
        Comparable element = (Comparable)o;
        Node<Comparable>[] path = this.getPath(element);
        Node node = path[this.indexLevel - 1];
        if (node.element == null || element.compareTo(node.element) != 0) {
            return false;
        }
        while (node != null) {
            if (element.equals(node.element)) {
                return true;
            }
            node = node.repeat;
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            Node<E> c = null;
            Node<E> r = null;

            @Override
            public boolean hasNext() {
                if (this.c == null) {
                    return SkipList.this.first != null;
                }
                return this.c.next != null || this.r.repeat != null;
            }

            @Override
            public E next() {
                if (this.c == null) {
                    this.c = SkipList.this.first;
                    this.r = SkipList.this.first;
                } else if (this.r.repeat != null) {
                    this.r = this.r.repeat;
                } else {
                    this.c = this.c.next;
                    this.r = this.c;
                }
                return this.r.element;
            }
        };
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[this.size];
        int i = 0;
        for (Comparable item : this) {
            array[i++] = item;
        }
        return array;
    }

    @Override
    public <T> T[] toArray(T[] array) {
        return this.toArray();
    }

    @Override
    public boolean add(E element) {
        if (element == null) {
            return false;
        }
        Node<E>[] path = this.getPath(element);
        Node<E> node = path[this.indexLevel];
        if (((Node)node).element != null && element.compareTo((Comparable)((Node)node).element) == 0) {
            do {
                if (!element.equals(((Node)node).element)) continue;
                return false;
            } while ((node = ((Node)node).repeat) != null);
            ((Node)path[this.indexLevel]).repeat = (Node)new Node<E>(element, null, null);
            ++this.size;
            return true;
        }
        int level = this.randomLevel();
        Node<E>[] headerPath = this.getOrCreateHeaderPath(level);
        node = null;
        int diff = level - path.length + 1;
        for (int i = level; i >= 0; --i) {
            int pathIndex = i - diff;
            if (pathIndex >= 0) {
                node = new Node<E>(element, path[pathIndex], ((Node)path[pathIndex]).next, node);
                ((Node)path[pathIndex]).next = (Node)node;
                if (((Node)node).down == null) {
                    this.last = ((Node)node).next == null ? node : this.last;
                    this.first = ((Node)path[pathIndex]).element == null ? node : this.first;
                }
            } else {
                node = new Node<E>(element, headerPath[i], ((Node)headerPath[i]).next, node);
                ((Node)headerPath[i]).next = (Node)node;
            }
            if (((Node)node).next == null) continue;
            ((Node)node).next.prev = (Node)node;
        }
        ++this.size;
        return true;
    }

    @Override
    public boolean remove(Object o) {
        if (!(o instanceof Comparable) || this.isEmpty()) {
            return false;
        }
        Comparable element = (Comparable)o;
        Node<Comparable>[] path = this.getPath(element);
        Node node = path[this.indexLevel];
        if (node.element == null || element.compareTo(node.element) != 0) {
            return false;
        }
        Node repeatUp = null;
        while (node != null && !element.equals(node.element)) {
            repeatUp = node;
            node = node.repeat;
        }
        if (node == null) {
            return false;
        }
        if (repeatUp != null) {
            repeatUp.repeat = node.repeat;
        } else if (node.repeat != null) {
            node.element = node.repeat.element;
            node.repeat = node.repeat.repeat;
        } else {
            for (int i = path.length - 1; i >= 0 && ((Node)path[i]).element == element; --i) {
                ((Node)path[i]).prev.next = ((Node)path[i]).next;
                if (((Node)path[i]).down != null) continue;
                this.last = ((Node)path[i]).next == null ? ((Node)path[i]).prev : this.last;
                this.first = ((Node)path[i]).prev.element == null ? ((Node)path[i]).next : this.first;
            }
        }
        --this.size;
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object e : c) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean result = false;
        for (Comparable e : c) {
            if (!this.add((E)e)) continue;
            result = true;
        }
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean result = false;
        for (Object e : c) {
            if (!this.remove(e)) continue;
            result = true;
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return false;
    }

    @Override
    public void clear() {
        this.size = 0;
        this.indexLevel = 0;
        this.header = new Node<Object>(null, null, null);
        this.first = null;
        this.last = null;
    }

    public E removeFirst() {
        E node = this.getFirst();
        this.remove(node);
        return node;
    }

    public E removeLast() {
        E node = this.getLast();
        this.remove(node);
        return node;
    }

    public E pollFirst() {
        return this.peekFirst() == null ? null : (E)this.removeFirst();
    }

    public E pollLast() {
        return this.peekLast() == null ? null : (E)this.removeLast();
    }

    public E getFirst() {
        if (this.first == null) {
            throw new NoSuchElementException();
        }
        return (E)((Node)this.first).element;
    }

    public E getLast() {
        if (this.last == null) {
            throw new NoSuchElementException();
        }
        return (E)((Node)this.last).element;
    }

    public E peekFirst() {
        return (E)(this.first != null ? ((Node)this.first).element : null);
    }

    public E peekLast() {
        return (E)(this.last != null ? ((Node)this.last).element : null);
    }

    public int levels() {
        return this.indexLevel;
    }

    public String toString() {
        String items;
        Iterator<E> it = this.iterator();
        if (!it.hasNext()) {
            items = "[]";
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            while (true) {
                Comparable e;
                sb.append((e = (Comparable)it.next()) == this ? "(this Collection)" : e);
                if (!it.hasNext()) {
                    items = sb.append(']').toString();
                    break;
                }
                sb.append(',').append(' ');
            }
        }
        return String.format("Level=%s%s", this.levels(), items);
    }

    private Node<E>[] getPath(E element) {
        Node[] path = new Node[this.indexLevel + 1];
        Node c = this.header;
        for (int i = 0; i <= this.indexLevel; ++i) {
            Node<E> node;
            path[i] = node = this.forward(c, element);
            if (((Node)node).down == null) continue;
            c = ((Node)node).down;
        }
        return path;
    }

    private Node<E> forward(Node<E> current, E element) {
        while (current.next != null && element.compareTo((Comparable)current.next.element) >= 0) {
            current = current.next;
        }
        return current;
    }

    private int randomLevel() {
        int level;
        for (level = 0; level < 32 && ThreadLocalRandom.current().nextInt(100) < this.p; ++level) {
        }
        return level;
    }

    public Node<E>[] getOrCreateHeaderPath(int level) {
        int absentLevels = level - this.indexLevel;
        for (int i = 0; i < absentLevels; ++i) {
            this.header = new Node<Object>(null, null, null, this.header);
            ++this.indexLevel;
        }
        Node c = this.header;
        int skipLevels = this.indexLevel - level;
        for (int i = 0; i < skipLevels; ++i) {
            c = c.down;
        }
        Node[] path = new Node[level + 1];
        for (int i = 0; i <= level; ++i) {
            path[i] = c;
            c = c.down;
        }
        return path;
    }

    public SkipList<E> clone() {
        try {
            return (SkipList)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    public static class Node<E extends Comparable<E>> {
        private E element;
        private Node<E> prev;
        private Node<E> next;
        private final Node<E> down;
        private Node<E> repeat;

        public Node(E element, Node<E> prev, Node<E> next) {
            this(element, prev, next, null);
        }

        public Node(E element, Node<E> prev, Node<E> next, Node<E> down) {
            this.element = element;
            this.prev = prev;
            this.next = next;
            this.down = down;
        }
    }
}

