/*
 * Decompiled with CFR 0.152.
 */
package org.jiang.tools.date;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.Queue;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jiang.tools.date.CalendarUtils;
import org.jiang.tools.date.DateFormatUtils;

public class EasyDate {
    private Calendar calendar;
    private final Queue<Function<Calendar, Calendar>> process;

    public EasyDate(Date date) {
        this.calendar = this.createCalendar(date);
        this.process = new LinkedList<Function<Calendar, Calendar>>();
    }

    private Calendar createCalendar(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.setFirstDayOfWeek(2);
        return calendar;
    }

    public static EasyDate of(Date date) {
        return new EasyDate(date);
    }

    public static EasyDate of(LocalDate localDate) {
        Date date = Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
        return EasyDate.of(date);
    }

    public static EasyDate of(LocalDateTime localDateTime) {
        Date date = Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
        return EasyDate.of(date);
    }

    public static EasyDate of(int ms) {
        return EasyDate.of(new Date(ms));
    }

    public static EasyDate of(String dateStr) {
        Date date = DateFormatUtils.toDate(dateStr);
        return EasyDate.of(date);
    }

    public static EasyDate of(String dateStr, String pattern) {
        Date date = DateFormatUtils.toDate(dateStr, pattern);
        return EasyDate.of(date);
    }

    public boolean isEmpty() {
        return this.calendar == null;
    }

    private Calendar execute() {
        if (this.isEmpty()) {
            return null;
        }
        Calendar calendar = this.calendar;
        while (!this.process.isEmpty()) {
            calendar = this.process.poll().apply(calendar);
        }
        this.calendar = calendar;
        return calendar;
    }

    public static EasyDate now() {
        return EasyDate.of(new Date());
    }

    public Date value() {
        Calendar calendar = this.execute();
        if (calendar == null) {
            return null;
        }
        return new Date(calendar.getTime().getTime());
    }

    public LocalDateTime localValue() {
        Calendar calendar = this.execute();
        if (calendar == null) {
            return null;
        }
        return LocalDateTime.ofInstant(calendar.toInstant(), ZoneId.systemDefault());
    }

    public LocalDate localDateValue() {
        return this.localValue().toLocalDate();
    }

    public String stringValue() {
        return DateFormatUtils.toString(this.value());
    }

    public String stringValue(String pattern) {
        return DateFormatUtils.toString(this.value(), pattern);
    }

    public EasyDate startTime() {
        this.process.offer(CalendarUtils::startTime);
        return this;
    }

    public EasyDate endTime() {
        this.process.offer(CalendarUtils::endTime);
        return this;
    }

    public EasyDate weekStartDay() {
        this.process.offer(CalendarUtils::weekStartDay);
        return this;
    }

    public EasyDate weekEndDay() {
        this.process.offer(CalendarUtils::weekEndDay);
        return this;
    }

    public EasyDate monthStartDay() {
        this.process.offer(CalendarUtils::monthStartDay);
        return this;
    }

    public EasyDate monthEndDay() {
        this.process.offer(CalendarUtils::monthEndDay);
        return this;
    }

    public EasyDate yearStartDay() {
        this.process.offer(CalendarUtils::yearStartDay);
        return this;
    }

    public EasyDate yearEndDay() {
        this.process.offer(CalendarUtils::yearEndDay);
        return this;
    }

    public EasyDate yearStartMonth() {
        this.process.offer(CalendarUtils::yearStartMonth);
        return this;
    }

    public EasyDate yearEndMonth() {
        this.process.offer(CalendarUtils::yearEndMonth);
        return this;
    }

    public EasyDate time(String time) {
        String[] split = time.split(":");
        return this.time(Integer.parseInt(split[0]), Integer.parseInt(split[1]), split.length >= 3 ? Integer.parseInt(split[2]) : 0);
    }

    public EasyDate time(int hour, int min, int sec) {
        return this.extra(c -> {
            c.set(11, hour);
            c.set(12, min);
            c.set(13, sec);
        });
    }

    public EasyDate addSec(int offset) {
        this.process.offer(c -> CalendarUtils.addSec(c, offset));
        return this;
    }

    public EasyDate addMin(int offset) {
        this.process.offer(c -> CalendarUtils.addMin(c, offset));
        return this;
    }

    public EasyDate addHour(int offset) {
        this.process.offer(c -> CalendarUtils.addHour(c, offset));
        return this;
    }

    public EasyDate addDays(int offset) {
        this.process.offer(c -> CalendarUtils.addDays(c, offset));
        return this;
    }

    public EasyDate addWeek(int offset) {
        this.process.offer(c -> CalendarUtils.addWeek(c, offset));
        return this;
    }

    public EasyDate addMonth(int offset) {
        this.process.offer(c -> CalendarUtils.addMonth(c, offset));
        return this;
    }

    public EasyDate addYear(int offset) {
        this.process.offer(c -> CalendarUtils.addYear(c, offset));
        return this;
    }

    public EasyDate yesterday() {
        this.process.offer(c -> CalendarUtils.addDays(c, -1));
        return this;
    }

    public EasyDate tomorrow() {
        this.process.offer(c -> CalendarUtils.addDays(c, 1));
        return this;
    }

    public EasyDate extra(Consumer<Calendar> consumer) {
        this.process.offer(c -> {
            consumer.accept((Calendar)c);
            return c;
        });
        return this;
    }
}

