/*
 * Decompiled with CFR 0.152.
 */
package org.jiang.tools.geo;

public class EasyCoord {
    public static final byte COORD_SYS_WGS84 = 1;
    public static final byte COORD_SYS_GCJ02 = 2;
    public static final byte COORD_SYS_BD09 = 3;
    private final double lon;
    private final double lat;
    private final byte coordSys;

    public static EasyCoord ofGcj02(double lon, double lat) {
        return new EasyCoord(lon, lat, 2);
    }

    public static EasyCoord ofWgs84(double lon, double lat) {
        return new EasyCoord(lon, lat, 1);
    }

    public static EasyCoord ofBd09(double lon, double lat) {
        return new EasyCoord(lon, lat, 3);
    }

    public String getCoordSysText() {
        switch (this.coordSys) {
            case 1: {
                return "WGS84";
            }
            case 2: {
                return "GCJ02";
            }
            case 3: {
                return "BD09";
            }
        }
        return null;
    }

    public String toString() {
        return String.format(String.format("%s:lon=%s,lat=%s", this.getCoordSysText(), this.lon, this.lat), new Object[0]);
    }

    public double getLon() {
        return this.lon;
    }

    public double getLat() {
        return this.lat;
    }

    public byte getCoordSys() {
        return this.coordSys;
    }

    public EasyCoord(double lon, double lat, byte coordSys) {
        this.lon = lon;
        this.lat = lat;
        this.coordSys = coordSys;
    }
}

