/*
 * Decompiled with CFR 0.152.
 */
package org.jiang.tools.geo;

import org.jiang.tools.exception.BadArgumentException;
import org.jiang.tools.geo.CoordinateConverter;
import org.jiang.tools.geo.EasyCoord;
import org.jiang.tools.geo.LocationUtils;

public class EasyGeo {
    private EasyCoord coord;

    public EasyGeo(EasyCoord coord) {
        this.coord = coord;
    }

    public static EasyGeo of(EasyCoord coord) {
        return new EasyGeo(coord);
    }

    public static EasyGeo ofGcj02(double lon, double lat) {
        EasyCoord coord = EasyCoord.ofGcj02(lon, lat);
        return EasyGeo.of(coord);
    }

    public static EasyGeo ofWgs84(double lon, double lat) {
        EasyCoord coord = EasyCoord.ofWgs84(lon, lat);
        return EasyGeo.of(coord);
    }

    public static EasyGeo ofBd09(double lon, double lat) {
        EasyCoord coord = EasyCoord.ofBd09(lon, lat);
        return EasyGeo.of(coord);
    }

    public EasyCoord value() {
        return this.coord;
    }

    public EasyGeo toWgs84() {
        double[] result = null;
        switch (this.coord.getCoordSys()) {
            case 2: {
                result = CoordinateConverter.gcj02ToWgs84(this.coord.getLon(), this.coord.getLat());
                break;
            }
            case 3: {
                result = CoordinateConverter.bd09ToWgs84(this.coord.getLon(), this.coord.getLat());
            }
        }
        if (result != null) {
            this.coord = EasyCoord.ofWgs84((double)result[0], result[1]);
        }
        return this;
    }

    public EasyGeo toGcj02() {
        double[] result = null;
        switch (this.coord.getCoordSys()) {
            case 1: {
                result = CoordinateConverter.wgs84ToGcj02(this.coord.getLon(), this.coord.getLat());
                break;
            }
            case 3: {
                result = CoordinateConverter.bd09ToGcj02(this.coord.getLon(), this.coord.getLat());
            }
        }
        if (result != null) {
            this.coord = EasyCoord.ofGcj02((double)result[0], result[1]);
        }
        return this;
    }

    public EasyGeo toBd09() {
        double[] result = null;
        switch (this.coord.getCoordSys()) {
            case 1: {
                result = CoordinateConverter.wgs84ToBd09(this.coord.getLon(), this.coord.getLat());
                break;
            }
            case 2: {
                result = CoordinateConverter.gcj02ToBd09(this.coord.getLon(), this.coord.getLat());
            }
        }
        if (result != null) {
            this.coord = EasyCoord.ofBd09((double)result[0], result[1]);
        }
        return this;
    }

    public long calculateDistance(EasyGeo easyGeo) {
        return this.calculateDistance(easyGeo.coord);
    }

    public long calculateDistance(EasyCoord easyCoord) {
        if (easyCoord.getCoordSys() != this.coord.getCoordSys()) {
            throw new BadArgumentException(String.format("\u6240\u7528\u5750\u6807\u7cfb\u4e0d\u540c\uff0c\u65e0\u6cd5\u8fdb\u884c\u8ba1\u7b97\uff1a%s,%s", this.coord.getCoordSysText(), easyCoord.getCoordSysText()));
        }
        return this.calculateDistance(easyCoord.getLon(), easyCoord.getLat());
    }

    public long calculateDistance(double lon, double lat) {
        return LocationUtils.calculateDistance(this.coord.getLon(), this.coord.getLat(), lon, lat);
    }
}

