/*
 * Decompiled with CFR 0.152.
 */
package org.jiang.tools.geo;

import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.jiang.tools.exception.BadArgumentException;
import org.jiang.tools.geo.CoordinateConverter;
import org.jiang.tools.geo.EasyCoord;
import org.jiang.tools.geo.LocationUtils;

public class EasyGeoArea {
    private Path2D.Double path;
    private byte defaultCoordSys = (byte)-1;
    private boolean fixed = false;
    private long acreage = -1L;
    private final LinkedList<EasyCoord> coordList = new LinkedList();

    public EasyGeoArea() {
    }

    public EasyGeoArea(List<EasyCoord> coordList) {
        if (coordList == null || coordList.isEmpty()) {
            return;
        }
        this.defaultCoordSys = coordList.get(0).getCoordSys();
        this.coordList.addAll(coordList);
        this.coordList.forEach(this::lineTo);
    }

    public static EasyGeoArea of(List<EasyCoord> coordList) {
        return new EasyGeoArea(coordList);
    }

    public static EasyGeoArea ofGcj02() {
        return EasyGeoArea.coordSys((byte)2);
    }

    public static EasyGeoArea ofWgs84() {
        return EasyGeoArea.coordSys((byte)1);
    }

    public static EasyGeoArea ofBd09() {
        return EasyGeoArea.coordSys((byte)3);
    }

    public static EasyGeoArea coordSys(byte coordSys) {
        EasyGeoArea easyGeoArea = new EasyGeoArea();
        return easyGeoArea.setCoordSys(coordSys);
    }

    public EasyGeoArea setCoordSys(byte coordSys) {
        this.defaultCoordSys = coordSys;
        return this;
    }

    public EasyGeoArea add(List<EasyCoord> coordList) {
        if (coordList == null || coordList.isEmpty()) {
            return this;
        }
        coordList.forEach(this::add);
        return this;
    }

    public EasyGeoArea add(EasyCoord easyCoord) {
        if (this.defaultCoordSys == -1) {
            this.defaultCoordSys = easyCoord.getCoordSys();
        }
        if (this.fixed) {
            this.reset();
        }
        this.coordList.addLast(easyCoord);
        this.acreage = -1L;
        this.lineTo(easyCoord);
        return this;
    }

    public EasyGeoArea add(double lon, double lat) {
        if (this.defaultCoordSys == -1) {
            throw new BadArgumentException("\u65e0\u9ed8\u8ba4\u5750\u6807\u7cfb");
        }
        return this.add(new EasyCoord(lon, lat, this.defaultCoordSys));
    }

    private void lineTo(EasyCoord easyCoord) {
        double[] cartesian = CoordinateConverter.toCartesian(easyCoord.getLon(), easyCoord.getLat());
        if (this.path == null) {
            this.path = new Path2D.Double();
            this.path.moveTo(cartesian[0], cartesian[1]);
            return;
        }
        this.path.lineTo(cartesian[0], cartesian[1]);
    }

    public boolean contains(EasyCoord easyCoord) {
        return this.contains(easyCoord.getLon(), easyCoord.getLat());
    }

    public boolean contains(double lon, double lat) {
        this.fixed();
        double[] cartesian = CoordinateConverter.toCartesian(lon, lat);
        return this.path.contains(cartesian[0], cartesian[1]);
    }

    public long acreage() {
        if (this.acreage != -1L) {
            return this.acreage;
        }
        if (this.coordList.size() < 3) {
            throw new BadArgumentException("\u81f3\u5c11\u9700\u8981\u6dfb\u52a03\u4e2a\u5750\u6807\u70b9");
        }
        List<Point2D.Double> collect = this.coordList.stream().map(item -> new Point2D.Double(item.getLon(), item.getLat())).collect(Collectors.toList());
        this.acreage = (long)LocationUtils.calculateAcreage(collect);
        return this.acreage;
    }

    private void fixed() {
        if (this.coordList.size() < 3) {
            throw new BadArgumentException("\u81f3\u5c11\u9700\u8981\u6dfb\u52a03\u4e2a\u5750\u6807\u70b9");
        }
        if (this.fixed) {
            return;
        }
        this.lineTo(this.coordList.getFirst());
        this.path.closePath();
        this.fixed = true;
    }

    private void reset() {
        if (this.path == null) {
            return;
        }
        this.path = null;
        this.fixed = false;
        this.acreage = -1L;
        this.coordList.forEach(this::lineTo);
    }
}

