/*
 * Decompiled with CFR 0.152.
 */
package org.jiang.tools.geo;

import java.awt.geom.Point2D;
import java.util.List;

public class LocationUtils {
    private static final double SEMIMAJOR_AXIS = 6378245.0;
    private static final double METERS_DEGREE = 111321.37574886571;
    private static final double RADIANS_DEGREE = Math.PI / 180;

    public static long calculateDistance(double lon1, double lat1, double lon2, double lat2) {
        double radLat1 = lat1 * Math.PI / 180.0;
        double radLat2 = lat2 * Math.PI / 180.0;
        double a = radLat1 - radLat2;
        double b = lon1 * Math.PI / 180.0 - lon2 * Math.PI / 180.0;
        double distance = 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin(a / 2.0), 2.0) + Math.cos(radLat1) * Math.cos(radLat2) * Math.pow(Math.sin(b / 2.0), 2.0)));
        distance *= 6378245.0;
        distance = (double)Math.round(distance * 10000.0) / 10.0;
        return (long)distance;
    }

    public static double calculateAcreage(List<Point2D.Double> pointList) {
        double totalAngle = 0.0;
        int size = pointList.size();
        for (int i = 0; i < pointList.size(); ++i) {
            double bearing23;
            int i2 = (i + 1) % size;
            int i3 = (i + 2) % size;
            double bearing21 = LocationUtils.getBearing(pointList.get(i2), pointList.get(i));
            double angle = bearing21 - (bearing23 = LocationUtils.getBearing(pointList.get(i2), pointList.get(i3)));
            if (angle < 0.0) {
                angle += 360.0;
            }
            totalAngle += angle;
        }
        double planarTotalAngle = (double)(size - 2) * 180.0;
        double sphericalExcess = totalAngle - planarTotalAngle;
        if (sphericalExcess > 420.0) {
            totalAngle = (double)size * 360.0 - totalAngle;
            sphericalExcess = totalAngle - planarTotalAngle;
        } else if (sphericalExcess > 300.0 && sphericalExcess < 420.0) {
            sphericalExcess = Math.abs(360.0 - sphericalExcess);
        }
        return sphericalExcess * (Math.PI / 180) * 6378245.0 * 6378245.0;
    }

    private static double getBearing(Point2D.Double from, Point2D.Double to) {
        double lat1 = from.getY() * (Math.PI / 180);
        double lon1 = from.getX() * (Math.PI / 180);
        double lat2 = to.getY() * (Math.PI / 180);
        double lon2 = to.getX() * (Math.PI / 180);
        double angle = -Math.atan2(Math.sin(lon1 - lon2) * Math.cos(lat2), Math.cos(lat1) * Math.sin(lat2) - Math.sin(lat1) * Math.cos(lat2) * Math.cos(lon1 - lon2));
        if (angle < 0.0) {
            angle += Math.PI * 2;
        }
        angle = angle * 180.0 / Math.PI;
        return angle;
    }
}

