/*
 * Decompiled with CFR 0.152.
 */
package org.jiang.tools.json;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jiang.tools.exception.SystemException;

public class JsonUtils {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static String toJson(Object obj) {
        try {
            return OBJECT_MAPPER.writeValueAsString(obj);
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
    }

    public static <T> T toBean(String json, Class<T> cls) {
        try {
            return (T)OBJECT_MAPPER.readValue(json, cls);
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
    }

    public static <T> T toBean(Object obj, Class<T> cls) {
        return JsonUtils.toBean(JsonUtils.toJson(obj), cls);
    }

    public static <T> List<T> toList(String json, Class<T> cls) {
        List list = JsonUtils.toBean(json, List.class);
        return JsonUtils.toList(list, cls);
    }

    public static <T> List<T> toList(List<?> list, Class<T> cls) {
        ArrayList result = new ArrayList(list.size());
        list.forEach(obj -> result.add(JsonUtils.toBean(obj, cls)));
        return result;
    }

    public static JsonNode readTree(byte[] bytes) {
        try {
            return OBJECT_MAPPER.readTree(bytes);
        }
        catch (IOException e) {
            throw new SystemException(e);
        }
    }

    static {
        OBJECT_MAPPER.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }
}

