/*
 * Decompiled with CFR 0.152.
 */
package org.jiang.tools.math;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.jiang.tools.exception.DataStatusException;

public class EasyRatio {
    private static final BigDecimal RATIO_TOTAL = new BigDecimal(100);
    private BigDecimal total;
    private BigDecimal remained;
    private BigDecimal remainedRatio;
    private int scale = 2;

    public EasyRatio(BigDecimal total) {
        this.init(total);
    }

    private void init(BigDecimal total) {
        this.total = total;
        this.remained = new BigDecimal(total.toString());
        this.remainedRatio = new BigDecimal(RATIO_TOTAL.toString()).setScale(this.scale, RoundingMode.DOWN);
    }

    public static EasyRatio of(long total) {
        return EasyRatio.of(new BigDecimal(total));
    }

    public static EasyRatio of(int total) {
        return EasyRatio.of(new BigDecimal(total));
    }

    public static EasyRatio of(double total) {
        return EasyRatio.of(new BigDecimal(total));
    }

    public static EasyRatio of(float total) {
        return EasyRatio.of(new BigDecimal(total));
    }

    public static EasyRatio of(BigDecimal total) {
        return new EasyRatio(total);
    }

    public EasyRatio addTotal(long total) {
        return this.addTotal(new BigDecimal(total));
    }

    public EasyRatio addTotal(int total) {
        return this.addTotal(new BigDecimal(total));
    }

    public EasyRatio addTotal(double total) {
        return this.addTotal(new BigDecimal(total));
    }

    public EasyRatio addTotal(float total) {
        return this.addTotal(new BigDecimal(total));
    }

    public EasyRatio addTotal(BigDecimal total) {
        if (this.remainedRatio.compareTo(RATIO_TOTAL) < 0) {
            throw new DataStatusException("this ratio has already been used");
        }
        this.init(this.total.add(total));
        return this;
    }

    public EasyRatio setScale(int scale) {
        this.scale = Math.min(scale, 4);
        return this;
    }

    public float take(long value) {
        return this.take(new BigDecimal(value));
    }

    public float take(int value) {
        return this.take(new BigDecimal(value));
    }

    public float take(double value) {
        return this.take(new BigDecimal(value));
    }

    public float take(float value) {
        return this.take(new BigDecimal(value));
    }

    public float take(BigDecimal value) {
        if (this.remainedRatio.floatValue() == 0.0f || this.remained.floatValue() <= 0.0f) {
            return 0.0f;
        }
        if (value.compareTo(this.remained) >= 0) {
            float ratio = this.remainedRatio.floatValue();
            this.remainedRatio = new BigDecimal(0);
            return ratio;
        }
        BigDecimal ratioDecimal = value.multiply(RATIO_TOTAL).divide(this.total, this.scale, RoundingMode.DOWN);
        this.remained = this.remained.subtract(value);
        this.remainedRatio = this.remainedRatio.subtract(ratioDecimal).setScale(this.scale, RoundingMode.DOWN);
        return ratioDecimal.floatValue();
    }

    public boolean hasRemained() {
        return this.remainedRatio() > 0.0f;
    }

    public BigDecimal total() {
        return this.total;
    }

    public BigDecimal remained() {
        return this.remained;
    }

    public float remainedRatio() {
        return this.remainedRatio.floatValue();
    }
}

