/*
 * Decompiled with CFR 0.152.
 */
package org.jiang.tools.math;

import java.math.RoundingMode;

public class RoundRule {
    private final int scale;
    private final RoundingMode mode;

    public RoundRule(int scale, RoundingMode mode) {
        this.scale = scale;
        this.mode = mode;
    }

    public static RoundRule up(int scale) {
        return new RoundRule(scale, RoundingMode.UP);
    }

    public static RoundRule down(int scale) {
        return new RoundRule(scale, RoundingMode.DOWN);
    }

    public static RoundRule halfUp(int scale) {
        return new RoundRule(scale, RoundingMode.HALF_UP);
    }

    public static RoundRule halfDown(int scale) {
        return new RoundRule(scale, RoundingMode.HALF_DOWN);
    }

    public static RoundRule ceiling(int scale) {
        return new RoundRule(scale, RoundingMode.CEILING);
    }

    public static RoundRule floor(int scale) {
        return new RoundRule(scale, RoundingMode.FLOOR);
    }

    public int getScale() {
        return this.scale;
    }

    public RoundingMode getMode() {
        return this.mode;
    }
}

