/*
 * Decompiled with CFR 0.152.
 */
package org.jiang.tools.object;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.regex.Pattern;
import org.jiang.tools.collection.CollectionUtils;
import org.jiang.tools.exception.BadArgumentException;
import org.jiang.tools.exception.PropertyExtractException;
import org.jiang.tools.object.ReflectionUtils;
import org.jiang.tools.text.StringUtils;

public class EasyResolver {
    private static final String EXP_ROOT_SYMBOL = "$";
    private static final String EXP_FUN_SYMBOL = "$";
    private static final String EXP_SEPARATOR = ".";
    private static final Map<String, BiFunction<EasyResolver, Object, Object>> FUN_NAME_MAPPER = new HashMap<String, BiFunction<EasyResolver, Object, Object>>(2);
    private final Object sourceObject;
    private Reference<Map<String, Object>> cacheMap;

    public EasyResolver(Object obj) {
        if (obj == null) {
            throw new BadArgumentException();
        }
        this.sourceObject = obj;
        this.enableCache();
    }

    public static EasyResolver of(Object obj) {
        return new EasyResolver(obj);
    }

    public EasyResolver enableCache() {
        if (this.cacheMap == null || this.cacheMap.get() == null) {
            this.cacheMap = new SoftReference(new HashMap());
        }
        return this;
    }

    public EasyResolver disableCache() {
        this.cacheMap.clear();
        return this;
    }

    public Object get(String exp) {
        String[] elms;
        Object cacheObj;
        if (!EasyResolver.verifyExp(exp)) {
            return new PropertyExtractException();
        }
        if (exp.equals("$")) {
            return this.sourceObject;
        }
        if (this.cacheMap.get() != null && (cacheObj = Objects.requireNonNull(this.cacheMap.get()).get(exp)) != null) {
            return cacheObj;
        }
        Object currentObject = this.sourceObject;
        for (String elm : elms = exp.substring("$.".length()).split(Pattern.quote(EXP_SEPARATOR))) {
            currentObject = this.getProperty(currentObject, elm);
        }
        if (this.cacheMap.get() != null) {
            Objects.requireNonNull(this.cacheMap.get()).put(exp, currentObject);
        }
        return currentObject;
    }

    private Object getProperty(Object obj, String property) {
        if (obj == null) {
            return new PropertyExtractException("object is null");
        }
        if (property.startsWith("$")) {
            return FUN_NAME_MAPPER.get(property.substring("$".length())).apply(this, obj);
        }
        if (obj instanceof Map) {
            return ((Map)obj).get(property);
        }
        if (obj instanceof Collection) {
            int index = Integer.parseInt(property);
            return CollectionUtils.getElement((Collection)obj, index);
        }
        try {
            return ReflectionUtils.getFieldValue(obj, property);
        }
        catch (NoSuchFieldException e) {
            throw new PropertyExtractException(String.format("no such field [%s]", property));
        }
        catch (IllegalAccessException e) {
            throw new PropertyExtractException(String.format("get field fail [%s]", property));
        }
    }

    private Object firstFun(Object obj) {
        if (!(obj instanceof Collection)) {
            return new PropertyExtractException("object is not collection");
        }
        return CollectionUtils.getFirstElement((Collection)obj);
    }

    private Object lastFun(Object obj) {
        if (!(obj instanceof Collection)) {
            return new PropertyExtractException("object is not collection");
        }
        return CollectionUtils.getLastElement((Collection)obj);
    }

    public static boolean verifyExp(String exp) {
        String[] elms;
        if (StringUtils.isEmpty(exp)) {
            return false;
        }
        if (exp.equals("$")) {
            return true;
        }
        String prefix = "$.";
        if (!exp.startsWith(prefix) || prefix.length() == exp.length()) {
            return false;
        }
        exp = exp.substring(prefix.length());
        for (String elm : elms = exp.split(Pattern.quote(EXP_SEPARATOR))) {
            if (elm.isEmpty()) {
                return false;
            }
            if (!elm.startsWith("$")) continue;
            if (elm.length() == "$".length()) {
                return false;
            }
            if (FUN_NAME_MAPPER.containsKey(elm.substring("$".length()))) continue;
            return false;
        }
        return true;
    }

    static {
        FUN_NAME_MAPPER.put("first", EasyResolver::firstFun);
        FUN_NAME_MAPPER.put("last", EasyResolver::lastFun);
    }
}

