/*
 * Decompiled with CFR 0.152.
 */
package org.jiang.tools.object;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class ReflectionUtils {
    public static List<Field> getAllFields(Object obj) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> currentClass = obj.getClass(); currentClass != null; currentClass = currentClass.getSuperclass()) {
            Field[] declaredFields;
            for (Field field : declaredFields = currentClass.getDeclaredFields()) {
                field.setAccessible(true);
                fields.add(field);
            }
        }
        return fields;
    }

    public static Object getFieldValue(Object obj, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        for (Class<?> currentClass = obj.getClass(); currentClass != null; currentClass = currentClass.getSuperclass()) {
            try {
                Field field = currentClass.getDeclaredField(fieldName);
                field.setAccessible(true);
                return field.get(obj);
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        throw new NoSuchFieldException("No such field: " + fieldName);
    }

    public static void setFieldValue(Object obj, String fieldName, Object value) throws NoSuchFieldException, IllegalAccessException {
        for (Class<?> currentClass = obj.getClass(); currentClass != null; currentClass = currentClass.getSuperclass()) {
            try {
                Field field = currentClass.getDeclaredField(fieldName);
                field.setAccessible(true);
                field.set(obj, value);
                return;
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        throw new NoSuchFieldException("No such field: " + fieldName);
    }
}

