/*
 * Decompiled with CFR 0.152.
 */
package org.jiang.tools.sql;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.function.Function;
import org.jiang.tools.data.EasyData;
import org.jiang.tools.exception.DataStatusException;
import org.jiang.tools.exception.SystemException;

public class SqlParser
implements Closeable {
    private static final long STATEMENT_MAX_LENGTH = 0xA00000L;
    private InputStream inputStream;
    private BufferedReader reader;
    private String residual;

    public SqlParser(InputStream inputStream) {
        this.inputStream = inputStream;
        if (inputStream.markSupported()) {
            inputStream.mark(0);
        }
    }

    public static SqlParser of(InputStream inputStream) {
        return new SqlParser(inputStream);
    }

    public static SqlParser of(String str) {
        return SqlParser.of(EasyData.of(str).streamValue());
    }

    public static SqlParser of(File file) throws IOException {
        return SqlParser.of(Files.newInputStream(file.toPath(), new OpenOption[0]));
    }

    private BufferedReader getReader() throws IOException {
        if (this.inputStream == null) {
            throw new DataStatusException("parser is closed");
        }
        if (this.reader != null && this.reader.ready()) {
            return this.reader;
        }
        this.reader = new BufferedReader(new InputStreamReader(this.inputStream));
        return this.reader;
    }

    public String read() throws IOException {
        String line;
        this.reader = this.getReader();
        StringBuilder sqlBuilder = new StringBuilder();
        long statementLength = 0L;
        while ((line = this.reader.readLine()) != null) {
            line = line.trim();
            sqlBuilder.append(line);
            if (line.endsWith(";")) {
                return sqlBuilder.toString();
            }
            if ((statementLength += (long)line.getBytes().length) <= 0xA00000L) continue;
            throw new SystemException("sql statement length exceed the limit");
        }
        return null;
    }

    public SqlParser read(Function<String, Boolean> fun) throws IOException {
        String sql;
        while ((sql = this.read()) != null && fun.apply(sql).booleanValue()) {
        }
        return this;
    }

    public SqlParser reset() throws IOException {
        this.inputStream.reset();
        this.reader = null;
        return this;
    }

    @Override
    public void close() throws IOException {
        if (this.inputStream == null) {
            return;
        }
        try {
            this.inputStream.close();
        }
        finally {
            this.inputStream = null;
            this.reader = null;
        }
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }
}

