/*
 * Decompiled with CFR 0.152.
 */
package org.jiang.tools.text;

import java.util.UUID;
import org.jiang.tools.exception.BadArgumentException;
import org.jiang.tools.lock.SpinLock;

public class IdUtils {
    public static String uuid() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static class SnowflakeFactory {
        private static final long START_TIMESTAMP = 1609459200000L;
        private static final long SEQUENCE_BIT = 12L;
        private static final long NODE_BIT = 10L;
        private static final long TIMESTAMP_BIT = 41L;
        private static final long MAX_SEQUENCE = 4095L;
        private static final long MAX_WORKER_ID = 1023L;
        private static final long WORKER_LEFT = 12L;
        private static final long TIMESTAMP_LEFT = 22L;
        private final long nodeId;
        private long sequence = 0L;
        private long lastTimestamp = -1L;
        private final SpinLock LOCK = new SpinLock();

        private SnowflakeFactory(long nodeId) {
            if (nodeId > 1023L || nodeId < 0L) {
                throw new BadArgumentException("Worker ID can't be greater than 1023 or less than 0");
            }
            this.nodeId = nodeId;
        }

        public static SnowflakeFactory create(long nodeId) {
            return new SnowflakeFactory(nodeId);
        }

        public long get() {
            this.LOCK.lock();
            long timestamp = System.currentTimeMillis();
            if (timestamp < this.lastTimestamp) {
                throw new RuntimeException("Clock moved backwards. Refusing to generate ID");
            }
            if (timestamp == this.lastTimestamp) {
                this.sequence = this.sequence + 1L & 0xFFFL;
                if (this.sequence == 0L) {
                    timestamp = System.currentTimeMillis();
                    while (timestamp <= this.lastTimestamp) {
                        timestamp = System.currentTimeMillis();
                    }
                }
            } else {
                this.sequence = 0L;
            }
            this.lastTimestamp = timestamp;
            long id = timestamp - 1609459200000L << 22 | this.nodeId << 12 | this.sequence;
            this.LOCK.unlock();
            return id;
        }
    }
}

