/*
 * Decompiled with CFR 0.152.
 */
package org.jiang.tools.text;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    private static final Pattern HUMP_PATTERN = Pattern.compile("[A-Z]");

    public static boolean isEmpty(CharSequence str) {
        return str == null || str.length() == 0;
    }

    public static boolean notEmpty(CharSequence str) {
        return !StringUtils.isEmpty(str);
    }

    public static boolean isNumber(CharSequence str) {
        return false;
    }

    public static String leftPad(String str, int length, char c) {
        StringBuilder sb = new StringBuilder();
        for (int i = length - str.length(); i > 0; --i) {
            sb.append(c);
        }
        return sb.append(str).toString();
    }

    public static String rightPad(String str, int length, char c) {
        StringBuilder sb = new StringBuilder(str);
        for (int i = length - str.length(); i > 0; --i) {
            sb.append(c);
        }
        return sb.toString();
    }

    public static String humpToLine(String str) {
        Matcher matcher = HUMP_PATTERN.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            if (matcher.start() == 0) {
                matcher.appendReplacement(sb, matcher.group().toLowerCase());
                continue;
            }
            matcher.appendReplacement(sb, "_" + matcher.group().toLowerCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String lineToHump(String str) {
        StringBuilder camelCaseBuilder = new StringBuilder();
        boolean capitalizeNextChar = false;
        for (char c : str.toCharArray()) {
            if (c == '_') {
                capitalizeNextChar = true;
                continue;
            }
            if (capitalizeNextChar) {
                camelCaseBuilder.append(Character.toUpperCase(c));
                capitalizeNextChar = false;
                continue;
            }
            camelCaseBuilder.append(Character.toLowerCase(c));
        }
        return camelCaseBuilder.toString();
    }
}

