/*
 * Decompiled with CFR 0.152.
 */
package org.jiang.tools.text;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringVerifyUtils {
    public static boolean isPhone(String str) {
        String regex = "^1[0-9]{10}$";
        return StringVerifyUtils.matchRegex(str, regex);
    }

    public static boolean isTelPhone(String str) {
        String regex = "^\\d{3,4}[-]\\d{7,8}$";
        return StringVerifyUtils.matchRegex(str, regex);
    }

    public static boolean isEmail(String str) {
        String regex = "^[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)*$";
        return StringVerifyUtils.matchRegex(str, regex);
    }

    public static boolean isIDCard(String str) {
        String regex = "^[1-9]\\d{5}(18|19|([23]\\d))\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{3}[0-9Xx]$";
        return StringVerifyUtils.matchRegex(str, regex);
    }

    public static boolean isCnUserName(String str) {
        String regex = "^(?:[\\u4e00-\\u9fa5\u00b7]{2,16})$";
        return StringVerifyUtils.matchRegex(str, regex);
    }

    public static boolean isEnUserName(String str) {
        String regex = "^[a-zA-Z][a-zA-Z\\s]{0,20}[a-zA-Z]$";
        return StringVerifyUtils.matchRegex(str, regex);
    }

    public static boolean isBankCard(String str) {
        String regex = "^[1-9]\\d{9,29}$";
        return StringVerifyUtils.matchRegex(str, regex);
    }

    public static boolean isCnLicencePlate(String str) {
        String regex = "^[\u4eac\u6d25\u6caa\u6e1d\u5180\u8c6b\u4e91\u8fbd\u9ed1\u6e58\u7696\u9c81\u65b0\u82cf\u6d59\u8d63\u9102\u6842\u7518\u664b\u8499\u9655\u5409\u95fd\u8d35\u7ca4\u9752\u85cf\u5ddd\u5b81\u743c\u4f7f\u9886][A-HJ-NP-Z][A-HJ-NP-Z0-9]{4,5}[A-HJ-NP-Z0-9\u6302\u5b66\u8b66\u6e2f\u6fb3]$";
        return StringVerifyUtils.matchRegex(str, regex);
    }

    public static boolean isAccount(String str) {
        String regex = "^[a-zA-Z]\\w{3,15}$";
        return StringVerifyUtils.matchRegex(str, regex);
    }

    public static boolean matchRegex(String str, String regex) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(str);
        return matcher.matches();
    }
}

