/*
 * Decompiled with CFR 0.152.
 */
package org.jiang.office.excel.element;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jiang.office.excel.element.ExcelElement;

public abstract class ExcelContainer
extends ExcelElement {
    public static final boolean DIRECTION_HORIZONTAL = true;
    public static final boolean DIRECTION_VERTICAL = false;
    private boolean direction = true;
    private List<ExcelElement> children;

    public ExcelContainer() {
    }

    public ExcelContainer(boolean direction) {
        this.setDirection(direction);
    }

    public boolean getDirection() {
        return this.direction;
    }

    public boolean isHorizontal() {
        return this.direction;
    }

    public boolean isVertical() {
        return !this.direction;
    }

    public void addElement(ExcelElement element) {
        if (this.children == null) {
            this.children = new ArrayList<ExcelElement>();
        }
        if (element != null) {
            this.children.add(element);
        }
    }

    public void addElement(ExcelElement ... elements) {
        if (this.children == null) {
            this.children = new ArrayList<ExcelElement>();
        }
        this.children.addAll(Arrays.stream(elements).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    public boolean replace(String id, ExcelElement element) {
        if (this.children == null) {
            return false;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            ExcelElement child = this.children.get(i);
            if (child.getId() != null && child.getId().equals(id)) {
                this.children.set(i, element);
                return true;
            }
            if (!(child instanceof ExcelContainer) || !((ExcelContainer)child).replace(id, element)) continue;
            return true;
        }
        return false;
    }

    public void setDirection(boolean direction) {
        this.direction = direction;
    }

    public List<ExcelElement> getChildren() {
        return this.children;
    }
}

