/*
 * Decompiled with CFR 0.152.
 */
package org.jiang.office.excel.element;

import java.util.Date;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Workbook;
import org.jiang.office.excel.element.ExcelCell;

public class ExcelDateCell
extends ExcelCell {
    private Date date;
    private String format;

    public ExcelDateCell(Date date) {
        this(date, "yyyy-MM-dd HH:mm:ss");
        this.date = date;
    }

    public ExcelDateCell(Date date, String format) {
        this.date = date;
        this.format = format;
    }

    public static ExcelDateCell of(Date date) {
        return new ExcelDateCell(date);
    }

    public static ExcelDateCell of(Date date, String format) {
        return new ExcelDateCell(date, format);
    }

    @Override
    public void updateCell(Cell cell, DataFormat dataFormat) {
        Workbook workbook = cell.getRow().getSheet().getWorkbook();
        CellStyle cellStyle = cell.getCellStyle();
        if (cellStyle == null) {
            cellStyle = workbook.createCellStyle();
        }
        cellStyle.setDataFormat(dataFormat.getFormat(this.format));
        cell.setCellValue(this.date);
    }

    public Date getDate() {
        return this.date;
    }

    public String getFormat() {
        return this.format;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public void setFormat(String format) {
        this.format = format;
    }
}

