/*
 * Decompiled with CFR 0.152.
 */
package org.jiang.office.excel.element;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Workbook;
import org.jiang.office.excel.element.ExcelCell;

public class ExcelNumberCell
extends ExcelCell {
    private Double number;
    private int precision;

    public ExcelNumberCell(Double number) {
        this(number, 2);
        this.number = number;
    }

    public ExcelNumberCell(Double number, int precision) {
        this.number = number;
        this.precision = precision;
    }

    public static ExcelNumberCell of(Double number) {
        return new ExcelNumberCell(number);
    }

    public static ExcelNumberCell of(Double number, int precision) {
        return new ExcelNumberCell(number, precision);
    }

    @Override
    public void updateCell(Cell cell, DataFormat dataFormat) {
        Workbook workbook = cell.getRow().getSheet().getWorkbook();
        CellStyle cellStyle = cell.getCellStyle();
        if (cellStyle == null) {
            cellStyle = workbook.createCellStyle();
        }
        cellStyle.setDataFormat(dataFormat.getFormat(this.getFormatStr()));
        cell.setCellValue(this.number.doubleValue());
    }

    private String getFormatStr() {
        StringBuilder sb = new StringBuilder("0");
        if (this.precision <= 0) {
            return sb.toString();
        }
        sb.append(".");
        for (int i = 0; i < this.precision; ++i) {
            sb.append("0");
        }
        return sb.toString();
    }

    public Double getNumber() {
        return this.number;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setNumber(Double number) {
        this.number = number;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }
}

