/*
 * Decompiled with CFR 0.152.
 */
package org.jiang.office.excel.exporter;

import java.util.Arrays;
import java.util.LinkedList;
import org.jiang.office.excel.element.ExcelCell;
import org.jiang.office.excel.element.ExcelContainer;
import org.jiang.office.excel.element.ExcelElement;

public class ElementFrame {
    private ExcelElement element;
    private int startRow;
    private int startCol;
    private int height;
    private int width;
    private ElementFrame parent;
    private LinkedList<ElementFrame> children;
    private CellMerge merge;

    public ElementFrame(ExcelElement element) {
        this.element = element;
    }

    public void add(ElementFrame ... frames) {
        if (this.children == null) {
            this.children = new LinkedList();
        }
        this.children.addAll(Arrays.asList(frames));
    }

    public void addHeight(int height) {
        this.height += height;
    }

    public void addWidth(int width) {
        this.width += width;
    }

    public boolean isCell() {
        return this.element instanceof ExcelCell;
    }

    protected void setPosition(int startRow, int startCol) {
        this.startRow = startRow;
        this.startCol = startCol;
    }

    protected void updateSize(int widthCapacity, int heightCapacity, boolean widthFill, boolean heightFill) {
        widthCapacity = widthFill ? widthCapacity : this.width;
        this.width = widthCapacity;
        heightCapacity = heightFill ? heightCapacity : this.height;
        this.height = heightCapacity;
        if (this.isCell()) {
            if (this.height == 1 && this.width == 1) {
                return;
            }
            this.merge = new CellMerge(this.startRow, this.startRow + this.height - 1, this.startCol, this.startCol + this.width - 1);
        }
        if (this.children == null) {
            return;
        }
        ExcelContainer container = (ExcelContainer)this.element;
        int startRow = this.startRow;
        int startCol = this.startCol;
        for (ElementFrame child : this.children) {
            boolean isLast = child == this.children.getLast();
            child.setPosition(startRow, startCol);
            if (container.isHorizontal()) {
                child.updateSize(widthCapacity, heightCapacity, isLast, true);
                startCol += child.getWidth();
                widthCapacity -= child.getWidth();
                continue;
            }
            child.updateSize(widthCapacity, heightCapacity, true, isLast);
            startRow += child.getHeight();
            heightCapacity -= child.getHeight();
        }
    }

    public ExcelElement getElement() {
        return this.element;
    }

    public int getStartRow() {
        return this.startRow;
    }

    public int getStartCol() {
        return this.startCol;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public ElementFrame getParent() {
        return this.parent;
    }

    public LinkedList<ElementFrame> getChildren() {
        return this.children;
    }

    public CellMerge getMerge() {
        return this.merge;
    }

    public void setElement(ExcelElement element) {
        this.element = element;
    }

    public void setStartRow(int startRow) {
        this.startRow = startRow;
    }

    public void setStartCol(int startCol) {
        this.startCol = startCol;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setParent(ElementFrame parent) {
        this.parent = parent;
    }

    public void setChildren(LinkedList<ElementFrame> children) {
        this.children = children;
    }

    public void setMerge(CellMerge merge) {
        this.merge = merge;
    }

    public static class CellMerge {
        private int startRow;
        private int endRow;
        private int startColumn;
        private int endColumn;

        public int getStartRow() {
            return this.startRow;
        }

        public int getEndRow() {
            return this.endRow;
        }

        public int getStartColumn() {
            return this.startColumn;
        }

        public int getEndColumn() {
            return this.endColumn;
        }

        public void setStartRow(int startRow) {
            this.startRow = startRow;
        }

        public void setEndRow(int endRow) {
            this.endRow = endRow;
        }

        public void setStartColumn(int startColumn) {
            this.startColumn = startColumn;
        }

        public void setEndColumn(int endColumn) {
            this.endColumn = endColumn;
        }

        public CellMerge() {
        }

        public CellMerge(int startRow, int endRow, int startColumn, int endColumn) {
            this.startRow = startRow;
            this.endRow = endRow;
            this.startColumn = startColumn;
            this.endColumn = endColumn;
        }
    }
}

