/*
 * Decompiled with CFR 0.152.
 */
package org.jiang.office.excel.exporter;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.jiang.office.excel.element.ExcelCell;
import org.jiang.office.excel.element.ExcelContainer;
import org.jiang.office.excel.element.ExcelElement;
import org.jiang.office.excel.element.ExcelTextCell;
import org.jiang.office.excel.exporter.ElementFrame;
import org.jiang.office.excel.exporter.ExcelExporter;
import org.jiang.office.excel.handler.ExcelCellHandler;
import org.jiang.office.excel.handler.ExcelCellMergeHandler;
import org.jiang.office.excel.handler.ExcelCellStyleHandler;
import org.jiang.office.excel.handler.ExcelCellValueHandler;
import org.jiang.office.excel.handler.ExcelPageHandler;

public class ExcelSimpleExporter
extends ExcelExporter {
    private static final int MAX_ROW_ACCESS = 10000;
    private final Collection<ExcelCellHandler> handlers = new LinkedList<ExcelCellHandler>();
    private final Map<String, ExcelContainer> sheets = new LinkedHashMap<String, ExcelContainer>();

    public ExcelSimpleExporter() {
        this.workbook = new SXSSFWorkbook(10000);
        this.handlers.add(new ExcelCellStyleHandler());
        this.handlers.add(new ExcelCellMergeHandler());
        this.handlers.add(new ExcelCellValueHandler());
        this.handlers.add(new ExcelPageHandler());
        for (ExcelCellHandler handler : this.handlers) {
            handler.initialize(this.workbook);
        }
    }

    public ExcelSimpleExporter(ExcelContainer container) {
        this();
        this.sheets.put(null, container);
    }

    public static ExcelSimpleExporter of(ExcelContainer container) {
        return new ExcelSimpleExporter(container);
    }

    public ExcelSimpleExporter addSheet(String name, ExcelContainer container) {
        this.sheets.put(name, container);
        return this;
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        for (String name : this.sheets.keySet()) {
            ExcelContainer container = this.sheets.get(name);
            this.createSheet(this.workbook, name, container);
        }
        this.workbook.write(outputStream);
    }

    private void createSheet(Workbook workbook, String name, ExcelContainer container) {
        Sheet sheet = name != null ? workbook.createSheet(name) : workbook.createSheet();
        ElementFrame rootFrame = this.createElementFrame(container);
        rootFrame.updateSize(rootFrame.getWidth(), rootFrame.getHeight(), true, true);
        ArrayList<Row> rows = new ArrayList<Row>(rootFrame.getHeight());
        for (int i = 0; i < rootFrame.getHeight(); ++i) {
            rows.add(sheet.createRow(i));
        }
        Stack<ElementFrame> stack = new Stack<ElementFrame>();
        stack.push(rootFrame);
        while (!stack.empty()) {
            ElementFrame frame = (ElementFrame)stack.pop();
            if (!frame.isCell()) {
                if (frame.getChildren() == null) continue;
                frame.getChildren().forEach(stack::push);
                continue;
            }
            Row row = (Row)rows.get(frame.getStartRow());
            Cell cell = row.createCell(frame.getStartCol());
            for (ExcelCellHandler handler : this.handlers) {
                handler.invoke(frame, cell);
            }
        }
        for (ExcelCellHandler handler : this.handlers) {
            handler.complete(rootFrame, sheet);
        }
    }

    private ElementFrame createElementFrame(ExcelElement element) {
        ElementFrame frame = new ElementFrame(element);
        if (frame.isCell()) {
            ExcelCell cell = (ExcelCell)element;
            frame.setWidth(cell.getColSpan());
            frame.setHeight(cell.getRowSpan());
            return frame;
        }
        ExcelContainer container = (ExcelContainer)element;
        if (container == null || container.getChildren() == null) {
            frame.setElement(ExcelTextCell.of(""));
            frame.setWidth(1);
            frame.setHeight(1);
            return frame;
        }
        for (ExcelElement child : container.getChildren()) {
            ElementFrame childFrame = this.createElementFrame(child);
            childFrame.setParent(frame);
            frame.add(childFrame);
            if (container.isHorizontal()) {
                frame.addWidth(childFrame.getWidth());
                frame.setHeight(Integer.max(frame.getHeight(), childFrame.getHeight()));
                continue;
            }
            frame.setWidth(Integer.max(frame.getWidth(), childFrame.getWidth()));
            frame.addHeight(childFrame.getHeight());
        }
        return frame;
    }
}

