/*
 * Decompiled with CFR 0.152.
 */
package org.jiang.office.excel.handler;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.jiang.office.excel.exporter.ElementFrame;
import org.jiang.office.excel.handler.ExcelCellHandler;

public class ExcelCellMergeHandler
implements ExcelCellHandler {
    @Override
    public void invoke(ElementFrame frame, Cell cell) {
        Sheet sheet = cell.getRow().getSheet();
        if (frame.getMerge() == null) {
            return;
        }
        int endRow = frame.getStartRow() + frame.getHeight() - 1;
        int endCol = frame.getStartCol() + frame.getWidth() - 1;
        for (int row = frame.getStartRow(); row <= endRow; ++row) {
            for (int col = frame.getStartCol(); col <= endCol; ++col) {
                if (row == frame.getStartRow() && col == frame.getStartCol()) continue;
                Cell emptyCell = sheet.getRow(row).createCell(col);
                emptyCell.setCellValue(false);
                emptyCell.setCellStyle(cell.getCellStyle());
            }
        }
        sheet.addMergedRegion(new CellRangeAddress(frame.getStartRow(), endRow, frame.getStartCol(), endCol));
    }
}

