/*
 * Decompiled with CFR 0.152.
 */
package org.jiang.office.excel.handler;

import java.util.HashMap;
import java.util.LinkedList;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Sheet;
import org.jiang.office.excel.exporter.ElementFrame;
import org.jiang.office.excel.handler.ExcelCellHandler;
import org.jiang.office.excel.style.ExcelCellStyle;

public class ExcelCellStyleHandler
implements ExcelCellHandler {
    private final HashMap<ExcelCellStyle, CellStyle> cellStyleMap = new HashMap();
    private final HashMap<ExcelCellStyle, Font> cellFontMap = new HashMap();

    @Override
    public void invoke(ElementFrame elementFrame, Cell cell) {
        LinkedList<ExcelCellStyle> styleList = new LinkedList<ExcelCellStyle>();
        for (ElementFrame c = elementFrame; c != null; c = c.getParent()) {
            ExcelCellStyle style = c.getElement().getStyle();
            if (style == null) continue;
            styleList.addFirst(style);
            if (!style.isInherit()) break;
        }
        if (styleList.isEmpty()) {
            return;
        }
        CellStyle cellStyle = this.getCellStyle(styleList, cell);
        Font cellFont = this.getCellFont(styleList, cell);
        cellStyle.setFont(cellFont);
        cell.setCellStyle(cellStyle);
        for (ExcelCellStyle excelCellStyle : styleList) {
            excelCellStyle.decorate(cellStyle, cellFont);
        }
    }

    @Override
    public void complete(ElementFrame rootFrame, Sheet sheet) {
        LinkedList<ElementFrame> list = new LinkedList<ElementFrame>();
        list.add(rootFrame);
        while (!list.isEmpty()) {
            int i;
            ElementFrame frame = (ElementFrame)list.pop();
            if (frame.getChildren() != null) {
                list.addAll(frame.getChildren());
            }
            if (frame.getElement().getStyle() == null) continue;
            if (frame.getElement().getStyle().getWidth() > 0) {
                int width = frame.getElement().getStyle().getWidth();
                int endCol = frame.getStartCol() + frame.getWidth() - 1;
                for (i = frame.getStartCol(); i <= endCol; ++i) {
                    sheet.setColumnWidth(i, width);
                }
            }
            if (frame.getElement().getStyle().getHeight() <= 0) continue;
            int height = frame.getElement().getStyle().getHeight();
            int endRow = frame.getStartRow() + frame.getHeight() - 1;
            for (i = frame.getStartRow(); i <= endRow; ++i) {
                sheet.getRow(i).setHeightInPoints((float)height);
            }
        }
    }

    private CellStyle getCellStyle(LinkedList<ExcelCellStyle> styleList, Cell cell) {
        return this.cellStyleMap.computeIfAbsent(styleList.getLast(), key -> cell.getRow().getSheet().getWorkbook().createCellStyle());
    }

    private Font getCellFont(LinkedList<ExcelCellStyle> styleList, Cell cell) {
        return this.cellFontMap.computeIfAbsent(styleList.getLast(), key -> cell.getRow().getSheet().getWorkbook().createFont());
    }
}

