/*
 * Decompiled with CFR 0.152.
 */
package org.jiang.office.excel.style;

import java.util.LinkedList;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;

public class ExcelCellStyle
implements Cloneable {
    private boolean inherit = true;
    private int width;
    private int height;
    private LinkedList<BiConsumer<CellStyle, Font>> process = new LinkedList();

    public ExcelCellStyle inherit(boolean inherit) {
        this.inherit = inherit;
        return this;
    }

    public ExcelCellStyle font(Consumer<Font> fun) {
        this.process.push((cellStyle, font) -> fun.accept((Font)font));
        return this;
    }

    public ExcelCellStyle style(Consumer<CellStyle> fun) {
        this.process.push((cellStyle, font) -> fun.accept((CellStyle)cellStyle));
        return this;
    }

    public void decorate(CellStyle cellStyle, Font font) {
        for (BiConsumer biConsumer : this.process) {
            biConsumer.accept(cellStyle, font);
        }
    }

    public ExcelCellStyle width(int width) {
        this.width = width;
        return this;
    }

    public ExcelCellStyle height(int height) {
        this.height = height;
        return this;
    }

    public ExcelCellStyle fontBold() {
        return this.fontBold(true);
    }

    public ExcelCellStyle fontBold(boolean bold) {
        return this.font(font -> font.setBold(bold));
    }

    public ExcelCellStyle fontName(String name) {
        return this.font(font -> font.setFontName(name));
    }

    public ExcelCellStyle fontHeight(int height) {
        return this.font(font -> font.setFontHeightInPoints((short)height));
    }

    public ExcelCellStyle fontColor(IndexedColors color) {
        return this.font(font -> font.setColor(color.getIndex()));
    }

    public ExcelCellStyle wrapText() {
        return this.wrapText(true);
    }

    public ExcelCellStyle wrapText(boolean wrap) {
        return this.style(style -> style.setWrapText(wrap));
    }

    public ExcelCellStyle backgroundColor(IndexedColors color) {
        return this.style(style -> {
            style.setFillForegroundColor(color.getIndex());
            style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        });
    }

    public ExcelCellStyle horizontalCenter() {
        return this.horizontalAlign(HorizontalAlignment.CENTER);
    }

    public ExcelCellStyle horizontalLeft() {
        return this.horizontalAlign(HorizontalAlignment.LEFT);
    }

    public ExcelCellStyle horizontalRight() {
        return this.horizontalAlign(HorizontalAlignment.RIGHT);
    }

    public ExcelCellStyle horizontalAlign(HorizontalAlignment alignment) {
        return this.style(style -> style.setAlignment(alignment));
    }

    public ExcelCellStyle verticalTop() {
        return this.verticalAlign(VerticalAlignment.TOP);
    }

    public ExcelCellStyle verticalCenter() {
        return this.verticalAlign(VerticalAlignment.CENTER);
    }

    public ExcelCellStyle verticalBottom() {
        return this.verticalAlign(VerticalAlignment.BOTTOM);
    }

    public ExcelCellStyle verticalAlign(VerticalAlignment alignment) {
        return this.style(style -> style.setVerticalAlignment(alignment));
    }

    public ExcelCellStyle borderTop(BorderStyle borderStyle) {
        return this.style(style -> style.setBorderTop(borderStyle));
    }

    public ExcelCellStyle borderBottom(BorderStyle borderStyle) {
        return this.style(style -> style.setBorderBottom(borderStyle));
    }

    public ExcelCellStyle borderLeft(BorderStyle borderStyle) {
        return this.style(style -> style.setBorderLeft(borderStyle));
    }

    public ExcelCellStyle borderRight(BorderStyle borderStyle) {
        return this.style(style -> style.setBorderRight(borderStyle));
    }

    public ExcelCellStyle borderColorTop(IndexedColors colors) {
        return this.style(style -> style.setTopBorderColor(colors.getIndex()));
    }

    public ExcelCellStyle borderColorBottom(IndexedColors colors) {
        return this.style(style -> style.setBottomBorderColor(colors.getIndex()));
    }

    public ExcelCellStyle borderColorLeft(IndexedColors colors) {
        return this.style(style -> style.setLeftBorderColor(colors.getIndex()));
    }

    public ExcelCellStyle borderColorRight(IndexedColors colors) {
        return this.style(style -> style.setRightBorderColor(colors.getIndex()));
    }

    public ExcelCellStyle borderColor(IndexedColors colors) {
        this.borderColorTop(colors);
        this.borderColorBottom(colors);
        this.borderColorLeft(colors);
        this.borderColorRight(colors);
        return this;
    }

    public ExcelCellStyle border(BorderStyle borderStyle) {
        this.borderTop(borderStyle);
        this.borderBottom(borderStyle);
        this.borderLeft(borderStyle);
        this.borderRight(borderStyle);
        return this;
    }

    public ExcelCellStyle border() {
        this.border(BorderStyle.THIN);
        this.borderColor(IndexedColors.BLACK1);
        return this;
    }

    public ExcelCellStyle clone() {
        try {
            ExcelCellStyle clone = (ExcelCellStyle)super.clone();
            clone.process = new LinkedList<BiConsumer<CellStyle, Font>>(clone.process);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean isInherit() {
        return this.inherit;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

