/*
 * Decompiled with CFR 0.152.
 */
package top.fangwenmagician.calculationstring;

import java.util.LinkedList;
import java.util.List;
import top.fangwenmagician.calculationstring.CalculationString;
import top.fangwenmagician.calculationstring.I_CalculationConfigure;
import top.fangwenmagician.calculationstring.OperatorGroup;
import top.fangwenmagician.calculationstring.exception.FactoryException;
import top.fangwenmagician.calculationstring.operator.Add;
import top.fangwenmagician.calculationstring.operator.Brackets;
import top.fangwenmagician.calculationstring.operator.Divide;
import top.fangwenmagician.calculationstring.operator.I_Operator;
import top.fangwenmagician.calculationstring.operator.Multiply;
import top.fangwenmagician.calculationstring.operator.Subtract;

public class CalculationFactory
implements I_CalculationConfigure {
    private final List<I_Operator> operatorList = new LinkedList<I_Operator>();
    private Object configure;

    public <T extends I_Operator> CalculationFactory addOperator(T operator) {
        this.operatorList.add(operator);
        return this;
    }

    public void empty() {
        this.operatorList.clear();
    }

    public void addDefaultOperator() {
        this.operatorList.add(new Add());
        this.operatorList.add(new Subtract());
        this.operatorList.add(new Multiply());
        this.operatorList.add(new Divide());
        this.operatorList.add(new Brackets());
    }

    public CalculationString builder() throws Exception {
        if (this.operatorList.size() == 0) {
            throw new FactoryException("\u672a\u6dfb\u52a0\u8fd0\u7b97\u7b26\uff01");
        }
        LinkedList<OperatorGroup> operatorGroupList = new LinkedList<OperatorGroup>();
        CalculationString calculationString = new CalculationString(operatorGroupList, this.configure);
        block0: for (I_Operator operator : this.operatorList) {
            if (operatorGroupList.size() == 0) {
                OperatorGroup operatorGroup = this.newOperatorGroup(calculationString, operator);
                operatorGroupList.add(operatorGroup);
                continue;
            }
            for (int i = 0; i < operatorGroupList.size(); ++i) {
                OperatorGroup operatorGroup;
                OperatorGroup lOperatorGroup = operatorGroupList.get(i);
                if (operator.priority() > lOperatorGroup.getPriority()) {
                    operatorGroup = this.newOperatorGroup(calculationString, operator);
                    operatorGroupList.add(i, operatorGroup);
                    continue block0;
                }
                if (operator.priority() == lOperatorGroup.getPriority()) {
                    lOperatorGroup.addOperator(operator);
                    continue block0;
                }
                if (i != operatorGroupList.size() - 1) continue;
                operatorGroup = this.newOperatorGroup(calculationString, operator);
                operatorGroupList.add(operatorGroup);
            }
        }
        return calculationString;
    }

    private OperatorGroup newOperatorGroup(CalculationString calculationString, I_Operator operator) throws Exception {
        OperatorGroup operatorGroup = new OperatorGroup(calculationString, operator.priority());
        operatorGroup.addOperator(operator);
        return operatorGroup;
    }

    public CalculationString builderDefault() throws Exception {
        this.addDefaultOperator();
        return this.builder();
    }

    public static CalculationString newDefaultCalculationString() throws Exception {
        return new CalculationFactory().builderDefault();
    }

    @Override
    public Object getConfigure() {
        return this.configure;
    }

    @Override
    public <T> T getConfigure(Class<T> tClass) {
        return tClass.cast(this.configure);
    }

    public void setConfigure(Object configure) {
        this.configure = configure;
    }
}

